/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.sampling.Sampler;
import co.elastic.apm.agent.impl.transaction.EpochTickClock;
import co.elastic.apm.agent.impl.transaction.Id;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import co.elastic.apm.agent.util.HexUtils;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public class TraceContext
extends TraceContextHolder {
    public static final String TRACE_PARENT_HEADER = "elastic-apm-traceparent";
    private static final int EXPECTED_LENGTH = 55;
    private static final int TRACE_ID_OFFSET = 3;
    private static final int PARENT_ID_OFFSET = 36;
    private static final int FLAGS_OFFSET = 53;
    private static final Logger logger = LoggerFactory.getLogger(TraceContext.class);
    private static final WeakConcurrentMap<ClassLoader, WeakReference<ClassLoader>> classLoaderWeakReferenceCache = new WeakConcurrentMap.WithInlinedExpunction<ClassLoader, WeakReference<ClassLoader>>();
    private static final ChildContextCreator<TraceContextHolder<?>> FROM_PARENT = new ChildContextCreator<TraceContextHolder<?>>(){

        @Override
        public boolean asChildOf(TraceContext child, TraceContextHolder<?> parent) {
            child.asChildOf(parent.getTraceContext());
            return true;
        }
    };
    private static final ChildContextCreator<String> FROM_TRACEPARENT_HEADER = new ChildContextCreator<String>(){

        @Override
        public boolean asChildOf(TraceContext child, String traceparent) {
            if (traceparent != null) {
                return child.asChildOf(traceparent);
            }
            return false;
        }
    };
    private static final ChildContextCreator<ElasticApmTracer> FROM_ACTIVE = new ChildContextCreator<ElasticApmTracer>(){

        @Override
        public boolean asChildOf(TraceContext child, ElasticApmTracer tracer) {
            TraceContextHolder<?> active = tracer.getActive();
            if (active != null) {
                return TraceContext.fromParent().asChildOf(child, active.getTraceContext());
            }
            return false;
        }
    };
    private static final ChildContextCreator<Object> AS_ROOT = new ChildContextCreator<Object>(){

        @Override
        public boolean asChildOf(TraceContext child, Object ignore) {
            return false;
        }
    };
    private static final int TRACE_PARENT_LENGTH = 55;
    private static final byte FLAG_RECORDED = 1;
    private final Id traceId = Id.new128BitId();
    private final Id id;
    private final Id parentId = Id.new64BitId();
    private final Id transactionId = Id.new64BitId();
    private final StringBuilder outgoingHeader = new StringBuilder(55);
    private byte flags;
    private boolean discard;
    @Nullable
    private WeakReference<ClassLoader> applicationClassLoader;
    private EpochTickClock clock = new EpochTickClock();
    @Nullable
    private String serviceName;

    private TraceContext(ElasticApmTracer tracer, Id id) {
        super(tracer);
        this.id = id;
    }

    public static TraceContext with64BitId(ElasticApmTracer tracer) {
        return new TraceContext(tracer, Id.new64BitId());
    }

    public static TraceContext with128BitId(ElasticApmTracer tracer) {
        return new TraceContext(tracer, Id.new128BitId());
    }

    public static ChildContextCreator<String> fromTraceparentHeader() {
        return FROM_TRACEPARENT_HEADER;
    }

    public static ChildContextCreator<ElasticApmTracer> fromActive() {
        return FROM_ACTIVE;
    }

    public static ChildContextCreator<TraceContextHolder<?>> fromParent() {
        return FROM_PARENT;
    }

    public static ChildContextCreator<?> asRoot() {
        return AS_ROOT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean asChildOf(String traceParentHeader) {
        traceParentHeader = traceParentHeader.trim();
        try {
            if (traceParentHeader.length() < 55) {
                logger.warn("The traceparent header has to be at least 55 chars long, but was '{}'", (Object)traceParentHeader);
                boolean bl = false;
                return bl;
            }
            if (!(this.hasDashAtPosition(traceParentHeader, 2) && this.hasDashAtPosition(traceParentHeader, 35) && this.hasDashAtPosition(traceParentHeader, 52))) {
                logger.warn("The traceparent header has an invalid format: '{}'", (Object)traceParentHeader);
                boolean bl = false;
                return bl;
            }
            if (traceParentHeader.length() > 55 && !this.hasDashAtPosition(traceParentHeader, 55)) {
                logger.warn("The traceparent header has an invalid format: '{}'", (Object)traceParentHeader);
                boolean bl = false;
                return bl;
            }
            if (traceParentHeader.startsWith("ff")) {
                logger.warn("Version ff is not supported");
                boolean bl = false;
                return bl;
            }
            byte version = HexUtils.getNextByte(traceParentHeader, 0);
            if (version == 0 && traceParentHeader.length() > 55) {
                logger.warn("The traceparent header has to be exactly 55 chars long for version 00, but was '{}'", (Object)traceParentHeader);
                boolean bl = false;
                return bl;
            }
            this.traceId.fromHexString(traceParentHeader, 3);
            if (this.traceId.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.parentId.fromHexString(traceParentHeader, 36);
            if (this.parentId.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.id.setToRandomValue();
            this.transactionId.copyFrom(this.id);
            this.flags = this.getTraceOptions(traceParentHeader);
            this.clock.init();
            boolean bl = true;
            return bl;
        }
        catch (IllegalArgumentException e) {
            logger.warn(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.onMutation();
        }
    }

    private boolean hasDashAtPosition(String traceParentHeader, int index) {
        return traceParentHeader.charAt(index) == '-';
    }

    public void asRootSpan(Sampler sampler) {
        this.traceId.setToRandomValue();
        this.id.setToRandomValue();
        this.transactionId.copyFrom(this.id);
        if (sampler.isSampled(this.traceId)) {
            this.flags = 1;
        }
        this.clock.init();
        this.onMutation();
    }

    public void asChildOf(TraceContext parent) {
        this.traceId.copyFrom(parent.traceId);
        this.parentId.copyFrom(parent.id);
        this.transactionId.copyFrom(parent.transactionId);
        this.flags = parent.flags;
        this.id.setToRandomValue();
        this.clock.init(parent.clock);
        this.serviceName = parent.serviceName;
        this.applicationClassLoader = parent.applicationClassLoader;
        this.onMutation();
    }

    private byte getTraceOptions(String traceParent) {
        return HexUtils.getNextByte(traceParent, 53);
    }

    @Override
    public void resetState() {
        super.resetState();
        this.traceId.resetState();
        this.id.resetState();
        this.parentId.resetState();
        this.transactionId.resetState();
        this.outgoingHeader.setLength(0);
        this.flags = 0;
        this.discard = false;
        this.clock.resetState();
        this.serviceName = null;
        this.applicationClassLoader = null;
    }

    public Id getTraceId() {
        return this.traceId;
    }

    public Id getId() {
        return this.id;
    }

    public Id getParentId() {
        return this.parentId;
    }

    public Id getTransactionId() {
        return this.transactionId;
    }

    public EpochTickClock getClock() {
        return this.clock;
    }

    @Override
    public boolean isSampled() {
        return this.isRecorded();
    }

    boolean isRecorded() {
        return (this.flags & 1) == 1;
    }

    void setRecorded(boolean recorded) {
        this.flags = recorded ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    @Override
    public void setDiscard(boolean discard) {
        this.discard = discard;
    }

    @Override
    public boolean isDiscard() {
        return this.discard;
    }

    public String getIncomingTraceParentHeader() {
        StringBuilder sb = new StringBuilder(55);
        this.fillTraceParentHeader(sb, this.parentId);
        return sb.toString();
    }

    public StringBuilder getOutgoingTraceParentHeader() {
        if (this.outgoingHeader.length() == 0) {
            this.fillTraceParentHeader(this.outgoingHeader, this.isSampled() ? this.id : this.transactionId);
        }
        return this.outgoingHeader;
    }

    private void fillTraceParentHeader(StringBuilder sb, Id spanId) {
        sb.append("00-");
        this.traceId.writeAsHex(sb);
        sb.append('-');
        spanId.writeAsHex(sb);
        sb.append('-');
        HexUtils.writeByteAsHex(this.flags, sb);
    }

    @Override
    public boolean isChildOf(TraceContextHolder parent) {
        return parent.getTraceContext().getTraceId().equals(this.traceId) && parent.getTraceContext().getId().equals(this.parentId);
    }

    public boolean hasContent() {
        return !this.id.isEmpty();
    }

    public void copyFrom(TraceContext other) {
        this.traceId.copyFrom(other.traceId);
        this.id.copyFrom(other.id);
        this.parentId.copyFrom(other.parentId);
        this.transactionId.copyFrom(other.transactionId);
        this.outgoingHeader.append((CharSequence)other.outgoingHeader);
        this.flags = other.flags;
        this.discard = other.discard;
        this.clock.init(other.clock);
        this.serviceName = other.serviceName;
        this.applicationClassLoader = other.applicationClassLoader;
        this.onMutation();
    }

    public String toString() {
        return this.getOutgoingTraceParentHeader().toString();
    }

    private void onMutation() {
        this.outgoingHeader.setLength(0);
    }

    public boolean isRoot() {
        return this.parentId.isEmpty();
    }

    @Nullable
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(@Nullable String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public TraceContext getTraceContext() {
        return this;
    }

    @Override
    public Span createSpan() {
        return this.tracer.startSpan(TraceContext.fromParent(), this);
    }

    @Override
    public Span createSpan(long epochMicros) {
        return this.tracer.startSpan(TraceContext.fromParent(), this, epochMicros);
    }

    void setApplicationClassLoader(@Nullable ClassLoader classLoader) {
        if (classLoader != null) {
            WeakReference<ClassLoader> local = classLoaderWeakReferenceCache.get(classLoader);
            if (local == null) {
                local = new WeakReference<ClassLoader>(classLoader);
                classLoaderWeakReferenceCache.putIfAbsent(classLoader, local);
            }
            this.applicationClassLoader = local;
        }
    }

    @Nullable
    public ClassLoader getApplicationClassLoader() {
        if (this.applicationClassLoader != null) {
            return (ClassLoader)this.applicationClassLoader.get();
        }
        return null;
    }

    public TraceContext copy() {
        TraceContext copy;
        int idLength = this.id.getLength();
        if (idLength == 8) {
            copy = TraceContext.with64BitId(this.tracer);
        } else if (idLength == 16) {
            copy = TraceContext.with128BitId(this.tracer);
        } else {
            throw new IllegalStateException("Id has invalid length: " + idLength);
        }
        copy.copyFrom(this);
        return copy;
    }

    @Override
    public Runnable withActive(Runnable runnable) {
        return this.tracer.wrapRunnable(runnable, this);
    }

    public Callable withActive(Callable callable) {
        return this.tracer.wrapCallable(callable, this);
    }

    public static interface ChildContextCreator<T> {
        public boolean asChildOf(TraceContext var1, T var2);
    }
}

