/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jaxrs;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.jaxrs.JaxRsConfiguration;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.annotation.AnnotationDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.annotation.AnnotationSource;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodList;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.ParameterDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeList;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JaxRsOffsetMappingFactory
implements Advice.OffsetMapping.Factory<JaxRsPath> {
    public static boolean useAnnotationValueForTransactionName;

    public JaxRsOffsetMappingFactory(ElasticApmTracer tracer) {
        useAnnotationValueForTransactionName = tracer.getConfig(JaxRsConfiguration.class).isUseJaxRsPathForTransactionName();
    }

    @Override
    public Class<JaxRsPath> getAnnotationType() {
        return JaxRsPath.class;
    }

    @Override
    public Advice.OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<JaxRsPath> annotation, Advice.OffsetMapping.Factory.AdviceType adviceType) {
        return new Advice.OffsetMapping(){

            @Override
            public Advice.OffsetMapping.Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Advice.ArgumentHandler argumentHandler, Advice.OffsetMapping.Sort sort) {
                String value = null;
                if (useAnnotationValueForTransactionName) {
                    value = JaxRsOffsetMappingFactory.this.getTransactionAnnotationValueFromAnnotations(instrumentedMethod, instrumentedType);
                }
                return Advice.OffsetMapping.Target.ForStackManipulation.of(value);
            }
        };
    }

    private String getTransactionAnnotationValueFromAnnotations(MethodDescription instrumentedMethod, TypeDescription instrumentedType) {
        TransactionAnnotationValue transactionAnnotationValue = new TransactionAnnotationValue();
        String methodName = instrumentedMethod.getName();
        while (!transactionAnnotationValue.isComplete() && !"java.lang.Object".equals(instrumentedType.getCanonicalName())) {
            this.getAnnotationValueFromAnnotationSource(transactionAnnotationValue, instrumentedType, true);
            for (MethodDescription.InDefinedShape annotationMethod : ((MethodList)instrumentedType.getDeclaredMethods().filter(ElementMatchers.named(methodName))).asDefined()) {
                this.getAnnotationValueFromAnnotationSource(transactionAnnotationValue, annotationMethod, false);
            }
            this.findInInterfaces(transactionAnnotationValue, instrumentedType, methodName);
            instrumentedType = instrumentedType.getSuperClass().asErasure();
        }
        return transactionAnnotationValue.buildTransactionName();
    }

    private void findInInterfaces(TransactionAnnotationValue transactionAnnotationValue, TypeDescription classTypeDescription, String methodName) {
        TypeList interfaces = classTypeDescription.getInterfaces().asErasures();
        for (int i = 0; i < interfaces.size(); ++i) {
            TypeDescription interfaceDescription = (TypeDescription)interfaces.get(i);
            this.getAnnotationValueFromAnnotationSource(transactionAnnotationValue, interfaceDescription, true);
            for (MethodDescription.InDefinedShape annotationMethod : (MethodList)interfaceDescription.getDeclaredMethods().filter(ElementMatchers.named(methodName))) {
                this.getAnnotationValueFromAnnotationSource(transactionAnnotationValue, annotationMethod, false);
            }
            this.findInInterfaces(transactionAnnotationValue, interfaceDescription, methodName);
        }
    }

    private void getAnnotationValueFromAnnotationSource(TransactionAnnotationValue transactionAnnotationValue, AnnotationSource annotationSource, Boolean isClassLevelPath) {
        for (TypeDescription classMethodTypeDescription : annotationSource.getDeclaredAnnotations().asTypeList()) {
            String canonicalName;
            switch (canonicalName = classMethodTypeDescription.getCanonicalName()) {
                case "javax.ws.rs.Path": {
                    String pathValue = (String)this.getAnnotationValue(annotationSource, classMethodTypeDescription, "value");
                    if (isClassLevelPath.booleanValue()) {
                        transactionAnnotationValue.setClassLevelPath(pathValue);
                        break;
                    }
                    transactionAnnotationValue.setMethodLevelPath(pathValue);
                    break;
                }
                case "javax.ws.rs.GET": {
                    transactionAnnotationValue.setMethodIfNotNull("GET");
                    break;
                }
                case "javax.ws.rs.POST": {
                    transactionAnnotationValue.setMethodIfNotNull("POST");
                    break;
                }
                case "javax.ws.rs.PUT": {
                    transactionAnnotationValue.setMethodIfNotNull("PUT");
                    break;
                }
                case "javax.ws.rs.DELETE": {
                    transactionAnnotationValue.setMethodIfNotNull("DELETE");
                    break;
                }
                case "javax.ws.rs.HEAD": {
                    transactionAnnotationValue.setMethodIfNotNull("HEAD");
                    break;
                }
                case "javax.ws.rs.OPTIONS": {
                    transactionAnnotationValue.setMethodIfNotNull("OPTIONS");
                }
            }
        }
    }

    @Nullable
    private <T> T getAnnotationValue(AnnotationSource annotationSource, TypeDescription annotationType, String method) {
        Iterator iterator = ((MethodList)annotationType.getDeclaredMethods().filter(ElementMatchers.named(method))).iterator();
        if (iterator.hasNext()) {
            MethodDescription.InDefinedShape annotationMethod = (MethodDescription.InDefinedShape)iterator.next();
            return (T)annotationSource.getDeclaredAnnotations().ofType(annotationType).getValue(annotationMethod).resolve();
        }
        return null;
    }

    public static class TransactionAnnotationValue {
        private String classLevelPath = "";
        private String method = "";
        private String methodLevelPath = "";

        private void setClassLevelPath(@Nullable String value) {
            if (value != null && this.classLevelPath.isEmpty()) {
                this.classLevelPath = this.ensureStartsWithSlash(value);
            }
        }

        private void setMethodLevelPath(@Nullable String value) {
            if (value != null && this.methodLevelPath.isEmpty()) {
                this.methodLevelPath = this.ensureStartsWithSlash(value);
            }
        }

        private void setMethodIfNotNull(@Nullable String value) {
            if (value != null && this.method.isEmpty()) {
                this.method = value;
            }
        }

        @Nonnull
        private String ensureStartsWithSlash(String value) {
            if (!value.startsWith("/")) {
                value = "/" + value;
            }
            if (value.endsWith("/")) {
                value = value.substring(0, value.length() - 1);
            }
            return value;
        }

        String buildTransactionName() {
            String path = this.classLevelPath + this.methodLevelPath;
            return this.method + " " + (path.isEmpty() ? "/" : path);
        }

        public boolean isComplete() {
            return !this.method.isEmpty() && !this.classLevelPath.isEmpty() && !this.methodLevelPath.isEmpty();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface JaxRsPath {
    }
}

