/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.HelperClassManager;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.jdbc.helper.JdbcHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;

public abstract class StatementInstrumentation
extends ElasticApmInstrumentation {
    @Nullable
    public static HelperClassManager<JdbcHelper> jdbcHelperManager;
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    StatementInstrumentation(ElasticApmTracer tracer, ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
        jdbcHelperManager = HelperClassManager.ForSingleClassLoader.of(tracer, "co.elastic.apm.agent.jdbc.helper.JdbcHelperImpl", "co.elastic.apm.agent.jdbc.helper.JdbcHelperImpl$1", "co.elastic.apm.agent.jdbc.helper.JdbcHelperImpl$ConnectionMetaData");
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Statement");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("java.sql.Statement")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("jdbc");
    }

    public static class ExecuteWithoutQueryInstrumentation
    extends StatementInstrumentation {
        public ExecuteWithoutQueryInstrumentation(ElasticApmTracer tracer) {
            super(tracer, ElementMatchers.nameStartsWith("execute").and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isPublic()));
        }

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Span onBeforeExecute(@Advice.This Statement statement) throws SQLException {
            JdbcHelper helperImpl;
            if (tracer != null && jdbcHelperManager != null && (helperImpl = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class)) != null) {
                String sql = JdbcHelper.retrieveSqlForStatement(statement);
                return helperImpl.createJdbcSpan(sql, statement.getConnection(), tracer.getActive(), true);
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Enter @Nullable Span span, @Advice.Thrown Throwable t) {
            if (span != null) {
                ((Span)((Span)span.captureException(t)).deactivate()).end();
            }
        }
    }

    public static class AddBatchInstrumentation
    extends StatementInstrumentation {
        public AddBatchInstrumentation(ElasticApmTracer tracer) {
            super(tracer, ElementMatchers.nameStartsWith("addBatch").and(ElementMatchers.takesArgument(0, String.class)).and(ElementMatchers.isPublic()));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void storeSql(@Advice.This Statement statement, @Advice.Argument(value=0) String sql) {
            JdbcHelper helperImpl;
            if (jdbcHelperManager != null && (helperImpl = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class)) != null) {
                JdbcHelper.mapStatementToSql(statement, sql);
            }
        }
    }

    public static class ExecuteWithQueryInstrumentation
    extends StatementInstrumentation {
        public ExecuteWithQueryInstrumentation(ElasticApmTracer tracer) {
            super(tracer, ElementMatchers.nameStartsWith("execute").and(ElementMatchers.takesArgument(0, String.class)).and(ElementMatchers.isPublic()));
        }

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Span onBeforeExecute(@Advice.This Statement statement, @Advice.Argument(value=0) String sql) throws SQLException {
            JdbcHelper helperImpl;
            if (tracer != null && jdbcHelperManager != null && (helperImpl = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class)) != null) {
                return helperImpl.createJdbcSpan(sql, statement.getConnection(), tracer.getActive(), false);
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Enter @Nullable Span span, @Advice.Thrown Throwable t) {
            if (span != null) {
                ((Span)((Span)span.captureException(t)).deactivate()).end();
            }
        }
    }
}

