/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc.helper;

import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.jdbc.helper.JdbcHelper;
import co.elastic.apm.agent.jdbc.signature.SignatureParser;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.annotation.Nullable;

public class JdbcHelperImpl
extends JdbcHelper {
    public static final String DB_SPAN_TYPE = "db";
    public static final String DB_SPAN_ACTION = "query";
    private static final Logger logger = LoggerFactory.getLogger(JdbcHelperImpl.class);
    private static final WeakConcurrentMap<Connection, ConnectionMetaData> metaDataMap = new WeakConcurrentMap(true);
    public static final ThreadLocal<SignatureParser> SIGNATURE_PARSER_THREAD_LOCAL = new ThreadLocal<SignatureParser>(){

        @Override
        protected SignatureParser initialValue() {
            return new SignatureParser();
        }
    };

    @Override
    @Nullable
    public Span createJdbcSpan(@Nullable String sql, Connection connection, @Nullable TraceContextHolder<?> parent, boolean preparedStatement) {
        if (sql == null || this.isAlreadyMonitored(parent) || parent == null || !parent.isSampled()) {
            return null;
        }
        Span span = (Span)parent.createSpan().activate();
        StringBuilder spanName = span.getAndOverrideName(0);
        if (spanName != null) {
            SIGNATURE_PARSER_THREAD_LOCAL.get().querySignature(sql, spanName, preparedStatement);
        }
        span.withType(DB_SPAN_TYPE);
        try {
            ConnectionMetaData connectionMetaData = this.getConnectionMetaData(connection);
            span.withSubtype(connectionMetaData.dbVendor).withAction(DB_SPAN_ACTION);
            span.getContext().getDb().withUser(connectionMetaData.user).withStatement(sql).withType("sql");
        }
        catch (SQLException e) {
            logger.warn("Ignored exception", e);
        }
        return span;
    }

    @Nullable
    private String getMethod(@Nullable String sql) {
        if (sql == null) {
            return null;
        }
        if (sql.startsWith("SELECT") || sql.startsWith("select")) {
            return "SELECT";
        }
        int indexOfWhitespace = (sql = sql.trim()).indexOf(32);
        if (indexOfWhitespace > 0) {
            return sql.substring(0, indexOfWhitespace).toUpperCase();
        }
        return sql.toUpperCase();
    }

    private boolean isAlreadyMonitored(@Nullable TraceContextHolder<?> parent) {
        if (!(parent instanceof Span)) {
            return false;
        }
        Span parentSpan = (Span)parent;
        return parentSpan.getType() != null && parentSpan.getType().equals(DB_SPAN_TYPE);
    }

    private ConnectionMetaData getConnectionMetaData(Connection connection) throws SQLException {
        ConnectionMetaData connectionMetaData = metaDataMap.get(connection);
        if (connectionMetaData == null) {
            DatabaseMetaData metaData = connection.getMetaData();
            String dbVendor = this.getDbVendor(metaData.getURL());
            connectionMetaData = new ConnectionMetaData(dbVendor, metaData.getUserName());
            metaDataMap.put(connection, connectionMetaData);
        }
        return connectionMetaData;
    }

    private String getDbVendor(String url) {
        String urlWithoutJdbc;
        int indexOfColonAfterVendor;
        int indexOfJdbc = url.indexOf("jdbc:");
        if (indexOfJdbc != -1 && (indexOfColonAfterVendor = (urlWithoutJdbc = url.substring(indexOfJdbc + 5)).indexOf(":")) != -1) {
            return urlWithoutJdbc.substring(0, indexOfColonAfterVendor);
        }
        return "unknown";
    }

    private static class ConnectionMetaData {
        final String dbVendor;
        final String user;

        private ConnectionMetaData(String dbVendor, String user) {
            this.dbVendor = dbVendor;
            this.user = user;
        }
    }
}

