/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jms;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.jms.BaseJmsInstrumentation;
import co.elastic.apm.agent.jms.JmsInstrumentationHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import javax.annotation.Nullable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;

public abstract class JmsMessageConsumerInstrumentation
extends BaseJmsInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(JmsMessageConsumerInstrumentation.class);

    JmsMessageConsumerInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Message").or(ElementMatchers.nameContains("Consumer")).or(ElementMatchers.nameContains("Receiver")).or(ElementMatchers.nameContains("Subscriber"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("javax.jms.MessageConsumer")));
    }

    public static class SetMessageListenerInstrumentation
    extends JmsMessageConsumerInstrumentation {
        public SetMessageListenerInstrumentation(ElasticApmTracer tracer) {
            super(tracer);
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("setMessageListener").and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.jms.MessageListener")));
        }

        @Override
        public Class<?> getAdviceClass() {
            return ListenerWrappingAdvice.class;
        }

        public static class ListenerWrappingAdvice {
            @Advice.OnMethodEnter(suppress=Throwable.class)
            public static void beforeSetListener(@Advice.Argument(value=0, readOnly=false) @Nullable MessageListener original) {
                JmsInstrumentationHelper<Destination, Message, MessageListener> helper = BaseJmsInstrumentation.jmsInstrHelperManager.getForClassLoaderOfClass(MessageListener.class);
                if (helper != null) {
                    original = helper.wrapLambda(original);
                }
            }
        }
    }

    public static class ReceiveInstrumentation
    extends JmsMessageConsumerInstrumentation {
        public ReceiveInstrumentation(ElasticApmTracer tracer) {
            super(tracer);
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("receive").and(ElementMatchers.takesArguments(0).or(ElementMatchers.takesArguments(1))).and(ElementMatchers.isPublic()).or(ElementMatchers.named("receiveNoWait").and(ElementMatchers.takesArguments(0).and(ElementMatchers.isPublic())));
        }

        @Override
        public Class<?> getAdviceClass() {
            return MessageConsumerAdvice.class;
        }

        public static class MessageConsumerAdvice {
            @Advice.OnMethodEnter(suppress=Throwable.class)
            @Nullable
            public static AbstractSpan beforeReceive(@Advice.Origin Class<?> clazz) {
                AbstractSpan abstractSpan = null;
                if (ElasticApmInstrumentation.tracer != null) {
                    TraceContextHolder<?> parent = ElasticApmInstrumentation.tracer.getActive();
                    if (parent == null) {
                        abstractSpan = ElasticApmInstrumentation.tracer.startTransaction(TraceContext.asRoot(), null, clazz.getClassLoader()).withType("messaging");
                    } else {
                        String parentType = null;
                        if (parent instanceof Transaction) {
                            parentType = ((Transaction)parent).getType();
                        } else if (parent instanceof Span) {
                            parentType = ((Span)parent).getType();
                        }
                        if (parentType != null && parentType.equals("messaging")) {
                            return null;
                        }
                        abstractSpan = parent.createSpan().withType("messaging").withSubtype("jms").withAction("receive");
                    }
                    abstractSpan.withName("JMS RECEIVE");
                    abstractSpan.activate();
                }
                return abstractSpan;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
            public static void afterReceive(@Advice.Enter @Nullable AbstractSpan abstractSpan, @Advice.Return @Nullable Message message, @Advice.Thrown Throwable throwable) {
                block13: {
                    if (abstractSpan != null) {
                        try {
                            if (message == null) break block13;
                            if (abstractSpan instanceof Transaction) {
                                try {
                                    String messageSenderContext = message.getStringProperty(JmsInstrumentationHelper.JMS_TRACE_PARENT_HEADER);
                                    if (messageSenderContext != null) {
                                        abstractSpan.getTraceContext().asChildOf(messageSenderContext);
                                    }
                                }
                                catch (JMSException e) {
                                    logger.error("Failed to retrieve trace context from Message", e);
                                }
                            }
                            try {
                                Destination destination = message.getJMSDestination();
                                if (destination instanceof Queue) {
                                    ((AbstractSpan)abstractSpan.appendToName(" from queue ")).appendToName(((Queue)destination).getQueueName());
                                } else if (destination instanceof Topic) {
                                    ((AbstractSpan)abstractSpan.appendToName(" from topic ")).appendToName(((Topic)destination).getTopicName());
                                }
                            }
                            catch (JMSException e) {
                                logger.warn("Failed to retrieve message's destination", e);
                            }
                        }
                        finally {
                            abstractSpan.captureException(throwable);
                            ((AbstractSpan)abstractSpan.deactivate()).end();
                        }
                    }
                }
            }
        }
    }
}

