/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.objectpool.impl;

import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.objectpool.impl.AbstractObjectPool;
import co.elastic.apm.agent.objectpool.impl.Resetter;
import co.elastic.apm.agent.shaded.lmax.disruptor.EventFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import javax.annotation.Nullable;

public class QueueBasedObjectPool<T>
extends AbstractObjectPool<T>
implements Collection<T> {
    private final Queue<T> queue;
    private final Resetter<T> resetter;

    public static <T extends Recyclable> QueueBasedObjectPool<T> ofRecyclable(Queue<T> queue, boolean preAllocate, Allocator<T> allocator) {
        return new QueueBasedObjectPool<T>(queue, preAllocate, allocator, Resetter.ForRecyclable.get());
    }

    public static <T> QueueBasedObjectPool<T> of(Queue<T> queue, boolean preAllocate, Allocator<T> allocator, Resetter<T> resetter) {
        return new QueueBasedObjectPool<T>(queue, preAllocate, allocator, resetter);
    }

    private QueueBasedObjectPool(Queue<T> queue, boolean preAllocate, Allocator<T> allocator, Resetter<T> resetter) {
        super(allocator);
        this.queue = queue;
        this.resetter = resetter;
        if (preAllocate) {
            for (int i = 0; i < this.queue.size(); ++i) {
                this.queue.offer(allocator.createInstance());
            }
        }
    }

    @Override
    @Nullable
    public T tryCreateInstance() {
        return this.queue.poll();
    }

    @Override
    public void recycle(T obj) {
        this.resetter.recycle(obj);
        this.queue.offer(obj);
    }

    @Override
    public int getObjectsInPool() {
        return this.queue.size();
    }

    @Override
    public void close() {
    }

    @Override
    public int getSize() {
        return this.queue.size();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.queue.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.queue.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.queue.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.queue.retainAll(c);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    private static class PooledObjectEventFactory<T>
    implements EventFactory<PooledObjectHolder<T>> {
        private PooledObjectEventFactory() {
        }

        @Override
        public PooledObjectHolder<T> newInstance() {
            return new PooledObjectHolder();
        }
    }

    private static class PooledObjectHolder<T> {
        @Nullable
        T value;

        private PooledObjectHolder() {
        }

        public void set(T value) {
            this.value = value;
        }
    }
}

