/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.objectpool.impl;

import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.objectpool.impl.AbstractObjectPool;
import javax.annotation.Nullable;

public class ThreadLocalObjectPool<T extends Recyclable>
extends AbstractObjectPool<T> {
    private final ThreadLocal<FixedSizeStack<T>> objectPool = new ThreadLocal();
    private final int maxNumPooledObjectsPerThread;
    private final boolean preAllocate;

    public ThreadLocalObjectPool(int maxNumPooledObjectsPerThread, boolean preAllocate, Allocator<T> allocator) {
        super(allocator);
        this.maxNumPooledObjectsPerThread = maxNumPooledObjectsPerThread;
        this.preAllocate = preAllocate;
    }

    @Override
    @Nullable
    public T tryCreateInstance() {
        return (T)((Recyclable)this.getStack().pop());
    }

    @Override
    public void recycle(T obj) {
        obj.resetState();
        this.getStack().push(obj);
    }

    @Override
    public int getObjectsInPool() {
        return this.getStack().size();
    }

    @Override
    public void close() {
        this.objectPool.remove();
    }

    @Override
    public int getSize() {
        return this.maxNumPooledObjectsPerThread;
    }

    private FixedSizeStack<T> getStack() {
        FixedSizeStack<T> stack = this.objectPool.get();
        if (stack == null) {
            stack = this.createStack(this.preAllocate);
            this.objectPool.set(stack);
        }
        return stack;
    }

    private FixedSizeStack<T> createStack(boolean preAllocate) {
        FixedSizeStack stack = new FixedSizeStack(this.maxNumPooledObjectsPerThread);
        if (preAllocate) {
            for (int i = 0; i < this.maxNumPooledObjectsPerThread; ++i) {
                stack.push(this.allocator.createInstance());
            }
        }
        return stack;
    }

    public static class FixedSizeStack<T> {
        private final T[] stack;
        private int top;

        FixedSizeStack(int maxSize) {
            this.stack = new Object[maxSize];
            this.top = -1;
        }

        boolean push(T obj) {
            int newTop = this.top + 1;
            if (newTop >= this.stack.length) {
                return false;
            }
            this.stack[newTop] = obj;
            this.top = newTop;
            return true;
        }

        @Nullable
        T pop() {
            if (this.top < 0) {
                return null;
            }
            T obj = this.stack[this.top--];
            this.stack[this.top + 1] = null;
            return obj;
        }

        int size() {
            return this.top + 1;
        }
    }
}

