/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentracing.impl;

import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.opentracing.impl.OpenTracingBridgeInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

public class SpanContextInstrumentation
extends OpenTracingBridgeInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.opentracing.TraceContextSpanContext");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("baggageItems");
    }

    @Advice.OnMethodExit(suppress=Throwable.class)
    public static void baggageItems(@Advice.FieldValue(value="traceContext", typing=Assigner.Typing.DYNAMIC) @Nullable TraceContext traceContext, @Advice.Return(readOnly=false) Iterable<Map.Entry<String, String>> baggage) {
        if (traceContext != null) {
            baggage = SpanContextInstrumentation.doGetBaggage(traceContext);
        }
    }

    public static Iterable<Map.Entry<String, String>> doGetBaggage(TraceContext traceContext) {
        return Collections.singletonMap("elastic-apm-traceparent", traceContext.getOutgoingTraceParentHeader().toString()).entrySet();
    }
}

