/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.HttpUtils;
import co.elastic.apm.agent.shaded.dslplatform.json.DslJson;
import co.elastic.apm.agent.shaded.dslplatform.json.JsonReader;
import co.elastic.apm.agent.shaded.dslplatform.json.MapConverter;
import co.elastic.apm.agent.shaded.dslplatform.json.Nullable;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.util.ExecutorUtils;
import co.elastic.apm.agent.util.Version;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;

public class ApmServerHealthChecker
implements Callable<Version> {
    private static final Logger logger = LoggerFactory.getLogger(ApmServerHealthChecker.class);
    private final ApmServerClient apmServerClient;
    private final DslJson<Object> dslJson = new DslJson();

    public ApmServerHealthChecker(ApmServerClient apmServerClient) {
        this.apmServerClient = apmServerClient;
    }

    public Future<Version> checkHealthAndGetMinVersion() {
        ThreadPoolExecutor pool = ExecutorUtils.createSingleThreadDeamonPool("apm-server-healthcheck", 1);
        try {
            Future<Version> future = pool.submit(this);
            return future;
        }
        finally {
            pool.shutdown();
        }
    }

    @Override
    @Nullable
    public Version call() {
        List<Version> versions = this.apmServerClient.executeForAllUrls("/", new ApmServerClient.ConnectionHandler<Version>(){

            @Override
            public Version withConnection(HttpURLConnection connection) {
                try {
                    int status;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Starting healthcheck to {}", (Object)connection.getURL());
                    }
                    if ((status = connection.getResponseCode()) >= 300) {
                        if (status == 404) {
                            throw new IllegalStateException("It seems like you are using a version of the APM Server which is not compatible with this agent. Please use APM Server 6.5.0 or newer.");
                        }
                        throw new IllegalStateException("Server returned status " + status);
                    }
                    String body = HttpUtils.getBody(connection);
                    logger.info("Elastic APM server is available: {}", (Object)body);
                    JsonReader reader = ApmServerHealthChecker.this.dslJson.newReader(body.getBytes(StandardCharsets.UTF_8));
                    reader.startObject();
                    String versionString = MapConverter.deserialize(reader).get("version");
                    return new Version(versionString);
                }
                catch (Exception e) {
                    logger.warn("Elastic APM server {} is not available ({})", (Object)connection.getURL(), (Object)e.getMessage());
                    return null;
                }
            }
        });
        versions.remove(null);
        if (!versions.isEmpty()) {
            return Collections.min(versions);
        }
        return null;
    }
}

