/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    private HttpUtils() {
    }

    public static String getBody(HttpURLConnection connection) {
        try {
            if (connection == null || connection.getInputStream() == null) {
                return null;
            }
            String body = HttpUtils.readInputStream(connection.getInputStream());
            return body;
        }
        catch (IOException e) {
            logger.error("Reading inputStream: {}", (Object)e.getMessage());
            try {
                String body = HttpUtils.readInputStream(connection.getErrorStream());
                return body;
            }
            catch (IOException e1) {
                logger.error("Reading errorStream: {}", (Object)e1.getMessage());
                return null;
            }
        }
    }

    private static String readInputStream(InputStream inputStream) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder bodyString = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            bodyString.append(line);
        }
        bufferedReader.close();
        return bodyString.toString();
    }
}

