/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.resttemplate;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.http.client.HttpClientHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public class SpringRestTemplateInstrumentation
extends ElasticApmInstrumentation {
    @Advice.OnMethodEnter(suppress=Throwable.class)
    private static void beforeExecute(@Advice.This ClientHttpRequest request, @Advice.Local(value="span") Span span) {
        if (tracer == null || tracer.getActive() == null) {
            return;
        }
        TraceContextHolder<?> parent = tracer.getActive();
        span = HttpClientHelper.startHttpClientSpan(parent, Objects.toString(request.getMethod()), request.getURI(), request.getURI().getHost());
        if (span != null) {
            span.activate();
            request.getHeaders().add("elastic-apm-traceparent", span.getTraceContext().getOutgoingTraceParentHeader().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    private static void afterExecute(@Advice.Return @Nullable ClientHttpResponse clientHttpResponse, @Advice.Local(value="span") @Nullable Span span, @Advice.Thrown @Nullable Throwable t) throws IOException {
        if (span != null) {
            try {
                if (clientHttpResponse != null) {
                    int statusCode = clientHttpResponse.getRawStatusCode();
                    span.getContext().getHttp().withStatusCode(statusCode);
                }
                span.captureException(t);
            }
            finally {
                ((Span)span.deactivate()).end();
            }
        }
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.nameStartsWith("org.springframework").and(ElementMatchers.not(ElementMatchers.isInterface())).and(ElementMatchers.declaresMethod(this.getMethodMatcher())).and(ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.http.client.ClientHttpRequest")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("execute").and(ElementMatchers.takesArguments(0)).and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.http.client.ClientHttpResponse"))));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("http-client", "spring-resttemplate");
    }
}

