/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.Scope;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.servlet.ServletTransactionHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.web.WebConfiguration;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletApiAdvice {
    @Nullable
    public static ServletTransactionHelper servletTransactionHelper;
    @Nullable
    public static ElasticApmTracer tracer;
    public static ThreadLocal<Boolean> excluded;

    static void init(ElasticApmTracer tracer) {
        ServletApiAdvice.tracer = tracer;
        servletTransactionHelper = new ServletTransactionHelper(tracer);
    }

    @Nullable
    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void onEnterServletService(@Advice.Argument(value=0) ServletRequest servletRequest, @Advice.Local(value="transaction") Transaction transaction, @Advice.Local(value="scope") Scope scope) {
        if (tracer == null) {
            return;
        }
        Transaction transactionAttr = (Transaction)servletRequest.getAttribute(ServletTransactionHelper.TRANSACTION_ATTRIBUTE);
        if (tracer.currentTransaction() == null && transactionAttr != null) {
            scope = transactionAttr.activateInScope();
        }
        if (servletTransactionHelper != null && servletRequest instanceof HttpServletRequest && servletRequest.getDispatcherType() == DispatcherType.REQUEST && !Boolean.TRUE.equals(excluded.get())) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            transaction = servletTransactionHelper.onBefore(request.getServletContext().getClassLoader(), request.getServletPath(), request.getPathInfo(), request.getHeader("User-Agent"), request.getHeader("elastic-apm-traceparent"));
            if (transaction == null) {
                excluded.set(Boolean.TRUE);
                return;
            }
            Request req = transaction.getContext().getRequest();
            if (transaction.isSampled() && tracer.getConfig(WebConfiguration.class).isCaptureHeaders()) {
                Enumeration headerNames;
                if (request.getCookies() != null) {
                    for (Cookie cookie : request.getCookies()) {
                        req.addCookie(cookie.getName(), cookie.getValue());
                    }
                }
                if ((headerNames = request.getHeaderNames()) != null) {
                    while (headerNames.hasMoreElements()) {
                        String headerName = (String)headerNames.nextElement();
                        req.addHeader(headerName, request.getHeaders(headerName));
                    }
                }
            }
            servletTransactionHelper.fillRequestContext(transaction, request.getProtocol(), request.getMethod(), request.isSecure(), request.getScheme(), request.getServerName(), request.getServerPort(), request.getRequestURI(), request.getQueryString(), request.getRemoteAddr(), request.getHeader("Content-Type"));
        }
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    public static void onExitServletService(@Advice.Argument(value=0) ServletRequest servletRequest, @Advice.Argument(value=1) ServletResponse servletResponse, @Advice.Local(value="transaction") @Nullable Transaction transaction, @Advice.Local(value="scope") @Nullable Scope scope, @Advice.Thrown @Nullable Throwable t, @Advice.This Object thiz) {
        Transaction currentTransaction;
        if (tracer == null) {
            return;
        }
        excluded.set(Boolean.FALSE);
        if (scope != null) {
            scope.close();
        }
        if (thiz instanceof HttpServlet && servletRequest instanceof HttpServletRequest && (currentTransaction = tracer.currentTransaction()) != null) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            ServletTransactionHelper.setTransactionNameByServletClass(httpServletRequest.getMethod(), thiz.getClass(), currentTransaction);
            Principal userPrincipal = httpServletRequest.getUserPrincipal();
            ServletTransactionHelper.setUsernameIfUnset(userPrincipal != null ? userPrincipal.getName() : null, currentTransaction.getContext());
        }
        if (servletTransactionHelper != null && transaction != null && servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            if (request.getAttribute(ServletTransactionHelper.ASYNC_ATTRIBUTE) != null) {
                transaction.deactivate();
            } else {
                HttpServletResponse response = (HttpServletResponse)servletResponse;
                if (transaction.isSampled() && tracer.getConfig(WebConfiguration.class).isCaptureHeaders()) {
                    Response resp = transaction.getContext().getResponse();
                    for (String headerName : response.getHeaderNames()) {
                        resp.addHeader(headerName, response.getHeaders(headerName));
                    }
                }
                String contentTypeHeader = request.getHeader("Content-Type");
                Map parameterMap = transaction.isSampled() && servletTransactionHelper.captureParameters(request.getMethod(), contentTypeHeader) ? request.getParameterMap() : null;
                servletTransactionHelper.onAfter(transaction, t, response.isCommitted(), response.getStatus(), request.getMethod(), parameterMap, request.getServletPath(), request.getPathInfo(), contentTypeHeader, true);
            }
        }
    }

    static {
        excluded = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
    }
}

