/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class ServletContextServiceNameInstrumentation
extends ElasticApmInstrumentation {
    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Servlet").or(ElementMatchers.nameContainsIgnoreCase("jsp"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("javax.servlet.Servlet")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("init").and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.servlet.ServletConfig"))).and(ElementMatchers.takesArguments(1));
    }

    @Override
    public Class<?> getAdviceClass() {
        return ServletContextServiceNameAdvice.class;
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("servlet-api", "servlet-service-name");
    }

    public static class ServletContextServiceNameAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onServletInit(@Nullable @Advice.Argument(value=0) ServletConfig servletConfig) {
            if (ElasticApmInstrumentation.tracer == null || servletConfig == null) {
                return;
            }
            ServletContext servletContext = servletConfig.getServletContext();
            if (servletContext == null) {
                return;
            }
            String serviceName = servletContext.getServletContextName();
            if ("application".equals(serviceName) || "".equals(serviceName) || "/".equals(serviceName)) {
                serviceName = null;
            }
            String contextPath = servletContext.getContextPath();
            if (serviceName == null && contextPath != null && !contextPath.isEmpty()) {
                serviceName = contextPath.substring(1);
            }
            if (serviceName != null) {
                ElasticApmInstrumentation.tracer.overrideServiceNameForClassLoader(servletContext.getClassLoader(), serviceName);
            }
        }
    }
}

