/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.dslplatform.json.processor;

import co.elastic.apm.agent.shaded.dslplatform.json.CompiledJson;
import co.elastic.apm.agent.shaded.dslplatform.json.Configuration;
import co.elastic.apm.agent.shaded.dslplatform.json.JsonAttribute;
import co.elastic.apm.agent.shaded.dslplatform.json.JsonConverter;
import co.elastic.apm.agent.shaded.dslplatform.json.JsonObject;
import co.elastic.apm.agent.shaded.dslplatform.json.JsonValue;
import co.elastic.apm.agent.shaded.dslplatform.json.Nullable;
import co.elastic.apm.agent.shaded.dslplatform.json.processor.AnnotationUsage;
import co.elastic.apm.agent.shaded.dslplatform.json.processor.AttributeInfo;
import co.elastic.apm.agent.shaded.dslplatform.json.processor.BuilderInfo;
import co.elastic.apm.agent.shaded.dslplatform.json.processor.ConverterInfo;
import co.elastic.apm.agent.shaded.dslplatform.json.processor.LogLevel;
import co.elastic.apm.agent.shaded.dslplatform.json.processor.ObjectType;
import co.elastic.apm.agent.shaded.dslplatform.json.processor.StructInfo;
import co.elastic.apm.agent.shaded.dslplatform.json.processor.TypeSupport;
import co.elastic.apm.agent.shaded.dslplatform.json.processor.UnknownTypes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class Analysis {
    private final AnnotationUsage annotationUsage;
    private final LogLevel logLevel;
    private final UnknownTypes unknownTypes;
    private final boolean onlyBasicFeatures;
    private final boolean includeFields;
    private final boolean includeBeanMethods;
    private final boolean includeExactMethods;
    private final Elements elements;
    private final Types types;
    private final Messager messager;
    public final TypeElement compiledJsonElement;
    public final DeclaredType compiledJsonType;
    public final TypeElement attributeElement;
    public final DeclaredType attributeType;
    public final TypeElement converterElement;
    public final DeclaredType converterType;
    private final TypeSupport typeSupport;
    private final Set<String> alternativeIgnore;
    private final Map<String, List<AnnotationMapping<Boolean>>> alternativeNonNullable;
    private final Map<String, String> alternativeAlias;
    private final Map<String, List<AnnotationMapping<Boolean>>> alternativeMandatory;
    private final Set<String> alternativeCreators;
    private final Map<String, String> alternativeIndex;
    private final Map<String, StructInfo> structs = new LinkedHashMap<String, StructInfo>();
    private boolean hasError;

    public boolean hasError() {
        return this.hasError;
    }

    public Analysis(ProcessingEnvironment processingEnv, AnnotationUsage annotationUsage, LogLevel logLevel, TypeSupport typeSupport) {
        this(processingEnv, annotationUsage, logLevel, typeSupport, null, null, null, null, null, null, UnknownTypes.ERROR, false, true, true, true);
    }

    public Analysis(ProcessingEnvironment processingEnv, AnnotationUsage annotationUsage, LogLevel logLevel, TypeSupport typeSupport, @Nullable Set<String> alternativeIgnore, @Nullable Map<String, List<AnnotationMapping<Boolean>>> alternativeNonNullable, @Nullable Map<String, String> alternativeAlias, @Nullable Map<String, List<AnnotationMapping<Boolean>>> alternativeMandatory, @Nullable Set<String> alternativeCreators, @Nullable Map<String, String> alternativeIndex, @Nullable UnknownTypes unknownTypes, boolean onlyBasicFeatures, boolean includeFields, boolean includeBeanMethods, boolean includeExactMethods) {
        this.annotationUsage = annotationUsage;
        this.logLevel = logLevel;
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.messager = processingEnv.getMessager();
        this.compiledJsonElement = this.elements.getTypeElement(CompiledJson.class.getName());
        this.compiledJsonType = this.types.getDeclaredType(this.compiledJsonElement, new TypeMirror[0]);
        this.attributeElement = this.elements.getTypeElement(JsonAttribute.class.getName());
        this.attributeType = this.types.getDeclaredType(this.attributeElement, new TypeMirror[0]);
        this.converterElement = this.elements.getTypeElement(JsonConverter.class.getName());
        this.converterType = this.types.getDeclaredType(this.converterElement, new TypeMirror[0]);
        this.typeSupport = typeSupport;
        this.alternativeIgnore = alternativeIgnore == null ? new HashSet() : alternativeIgnore;
        this.alternativeNonNullable = alternativeNonNullable == null ? new HashMap() : alternativeNonNullable;
        this.alternativeAlias = alternativeAlias == null ? new HashMap() : alternativeAlias;
        this.alternativeMandatory = alternativeMandatory == null ? new HashMap() : alternativeMandatory;
        this.alternativeCreators = alternativeCreators == null ? new HashSet() : alternativeCreators;
        this.alternativeIndex = alternativeIndex == null ? new HashMap() : alternativeIndex;
        this.unknownTypes = unknownTypes == null ? UnknownTypes.ERROR : unknownTypes;
        this.onlyBasicFeatures = onlyBasicFeatures;
        this.includeFields = includeFields;
        this.includeBeanMethods = includeBeanMethods;
        this.includeExactMethods = includeExactMethods;
    }

    public Map<String, Element> processConverters(Set<? extends Element> converters) {
        LinkedHashMap<String, Element> configurations = new LinkedHashMap<String, Element>();
        block0: for (Element element : converters) {
            this.findConverters(element);
            if (!(element instanceof TypeElement)) continue;
            TypeElement te = (TypeElement)element;
            if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            for (TypeElement it : this.getTypeHierarchy((TypeElement)element)) {
                if (!Configuration.class.getName().equals(it.toString())) continue;
                if (te.getNestingKind().isNested()) {
                    configurations.put(((Object)te.getEnclosingElement().asType()).toString() + "$" + te.getSimpleName().toString(), te);
                    continue block0;
                }
                configurations.put(((Object)te.asType()).toString(), te);
                continue block0;
            }
        }
        return configurations;
    }

    public void processAnnotation(DeclaredType currentAnnotationType, Set<? extends Element> targets) {
        Stack<String> path = new Stack<String>();
        for (Element element : targets) {
            Element classElement;
            ExecutableElement factory = null;
            ExecutableElement builder = null;
            if (element instanceof TypeElement) {
                classElement = element;
            } else if (element instanceof ExecutableElement && element.getKind() == ElementKind.METHOD) {
                ExecutableElement ee = (ExecutableElement)element;
                Element returnClass = this.types.asElement(ee.getReturnType());
                Element enclosing = ee.getEnclosingElement();
                if (!element.getModifiers().contains((Object)Modifier.STATIC) && !this.types.isSameType(ee.getReturnType(), enclosing.asType()) && returnClass.toString().equals(enclosing.getEnclosingElement().toString())) {
                    builder = ee;
                }
                factory = ee;
                classElement = returnClass;
            } else {
                classElement = element.getEnclosingElement();
            }
            this.findStructs(classElement, currentAnnotationType, currentAnnotationType + " requires accessible public constructor", path, factory, builder);
        }
        this.findRelatedReferences();
        this.findImplementations(this.structs.values());
    }

    public Map<String, StructInfo> analyze() {
        for (Map.Entry<String, StructInfo> it : this.structs.entrySet()) {
            String argName;
            StructInfo info = it.getValue();
            String className = it.getKey();
            if (info.type == ObjectType.CLASS && info.constructor == null && info.factory == null && info.builder == null && !info.hasKnownConversion() && info.matchingConstructors != null) {
                this.hasError = true;
                if (info.matchingConstructors.size() == 0) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "No matching constructors found for '" + info.element.asType() + "'. Make sure there is at least one matching constructor available.", info.element, info.annotation);
                } else {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Multiple matching constructors found for '" + info.element.asType() + "'. Use @CompiledJson or alternative annotations to select the appropriate constructor.", info.element, info.annotation);
                }
            }
            if (this.unknownTypes != UnknownTypes.ALLOW && !info.unknowns.isEmpty()) {
                for (Map.Entry entry : info.unknowns.entrySet()) {
                    AttributeInfo attr = info.attributes.get(entry.getKey());
                    if (attr != null && (attr.converter != null || attr.isJsonObject)) continue;
                    Map<String, PartKind> references = this.analyzeParts((TypeMirror)entry.getValue());
                    for (Map.Entry<String, PartKind> pair : references.entrySet()) {
                        switch (pair.getValue()) {
                            case UNKNOWN: {
                                Diagnostic.Kind kind;
                                this.hasError = this.hasError || this.unknownTypes == UnknownTypes.ERROR;
                                Diagnostic.Kind kind2 = kind = this.unknownTypes == UnknownTypes.ERROR ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
                                if (kind != Diagnostic.Kind.ERROR && !this.logLevel.isVisible(LogLevel.INFO)) break;
                                if (((Object)((TypeMirror)entry.getValue())).toString().equals(pair.getKey())) {
                                    this.messager.printMessage(kind, "Property " + (String)entry.getKey() + " is referencing unknown type: '" + entry.getValue() + "'. Register custom converter, mark property as ignored or enable unknown types", attr != null ? attr.element : info.element, info.annotation);
                                    break;
                                }
                                this.messager.printMessage(kind, "Property " + (String)entry.getKey() + " is referencing unknown type: '" + entry.getValue() + "' which has an unknown part: '" + pair.getKey() + "'. Register custom converter, mark property as ignored or enable unknown types", attr != null ? attr.element : info.element, info.annotation);
                                break;
                            }
                            case RAW_TYPE: {
                                Diagnostic.Kind kind;
                                if (this.structs.containsKey("java.lang.Object")) break;
                                this.hasError = this.hasError || this.unknownTypes == UnknownTypes.ERROR;
                                Diagnostic.Kind kind3 = kind = this.unknownTypes == UnknownTypes.ERROR ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
                                if (kind != Diagnostic.Kind.ERROR && !this.logLevel.isVisible(LogLevel.INFO)) break;
                                if (((Object)((TypeMirror)entry.getValue())).toString().equals(pair.getKey())) {
                                    this.messager.printMessage(kind, "Property " + (String)entry.getKey() + " is referencing raw type: '" + entry.getValue() + "'. Specify type arguments, register custom converter, mark property as ignored or enable unknown types", attr != null ? attr.element : info.element, info.annotation);
                                    break;
                                }
                                this.messager.printMessage(kind, "Property " + (String)entry.getKey() + " is referencing type: '" + entry.getValue() + "' which has a raw type part: '" + pair.getKey() + "'. Specify type arguments, register custom converter, mark property as ignored or enable unknown types", attr != null ? attr.element : info.element, info.annotation);
                            }
                        }
                    }
                }
            }
            if (this.unknownTypes != UnknownTypes.ALLOW) {
                for (AttributeInfo attributeInfo : info.attributes.values()) {
                    if (attributeInfo.converter != null || attributeInfo.isJsonObject) continue;
                    Map<String, PartKind> references = this.analyzeParts(attributeInfo.type);
                    for (String r : references.keySet()) {
                        StructInfo target = this.structs.get(r);
                        if (target == null || target.type != ObjectType.MIXIN || target.implementations.size() != 0) continue;
                        String what = target.element.getKind() == ElementKind.INTERFACE ? "interface" : "abstract class";
                        String one = target.element.getKind() == ElementKind.INTERFACE ? "implementation" : "concrete extension";
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Property " + attributeInfo.name + " is referencing " + what + " (" + target.element.getQualifiedName() + ") which doesn't have registered " + "implementations with @CompiledJson. At least one " + one + " of specified " + what + " must be annotated " + "with CompiledJson annotation or allow unknown types during analysis", attributeInfo.element, info.annotation);
                    }
                }
            }
            if (info.builder == null && this.unknownTypes != UnknownTypes.ALLOW && info.type == ObjectType.MIXIN && info.implementations.isEmpty()) {
                Diagnostic.Kind kind;
                String what = info.element.getKind() == ElementKind.INTERFACE ? "Interface" : "Abstract class";
                String string = info.element.getKind() == ElementKind.INTERFACE ? "implementation" : "concrete extension";
                this.hasError = this.hasError || this.unknownTypes == UnknownTypes.ERROR;
                Diagnostic.Kind kind4 = kind = this.unknownTypes == UnknownTypes.ERROR ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
                if (kind == Diagnostic.Kind.ERROR || this.logLevel.isVisible(LogLevel.INFO)) {
                    this.messager.printMessage(kind, what + " (" + className + ") is referenced, but it doesn't have registered " + "implementations with @CompiledJson. At least one " + string + " of specified " + what + " must be annotated " + "with CompiledJson annotation or allow unknown types during analysis", info.element, info.annotation);
                }
            }
            if (info.type == ObjectType.CLASS && !info.hasKnownConversion() && info.factory != null) {
                if (this.onlyBasicFeatures) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Factory methods are not available with current analysis setup. Use annotation processor which supports such feature", info.factory, info.annotation);
                } else if (!this.types.isAssignable(info.factory.getReturnType(), info.element.asType())) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Wrong factory result type: '" + info.factory.getReturnType() + "'. Result must be assignable to '" + info.element.asType() + "'", info.factory, info.annotation);
                } else {
                    for (VariableElement variableElement : info.factory.getParameters()) {
                        boolean found = false;
                        argName = variableElement.getSimpleName().toString();
                        for (AttributeInfo attr : info.attributes.values()) {
                            if (!attr.name.equals(argName)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to find matching property: '" + argName + "' used in method factory. Either use annotation processor on source code, on bytecode with -parameters flag (to enable parameter names) or manually create an instance via converter", info.factory, info.annotation);
                    }
                }
            }
            if (info.type == ObjectType.CLASS && info.hasAnnotation() && !info.hasKnownConversion() && info.attributes.isEmpty() && info.implementations.isEmpty()) {
                boolean isUsedAsImplementation = false;
                for (StructInfo si : this.structs.values()) {
                    if (!si.implementations.contains(info)) continue;
                    isUsedAsImplementation = true;
                    break;
                }
                if (!isUsedAsImplementation) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "No properties found on: '" + info.element + "'. Since it's not used as implementation for some mixin, it's most likely an invalid class configuration (name mismatch, missing setter, etc...)", info.factory, info.annotation);
                }
            }
            if (info.type == ObjectType.CLASS && !info.hasKnownConversion() && !info.hasEmptyCtor() && info.constructor != null && info.factory == null) {
                for (VariableElement variableElement : info.constructor.getParameters()) {
                    boolean found = false;
                    argName = variableElement.getSimpleName().toString();
                    for (AttributeInfo attr : info.attributes.values()) {
                        if (!attr.name.equals(argName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to find matching property: '" + argName + "' used in constructor. Either use annotation processor on source code, on bytecode with -parameters flag (to enable parameter names) or manually create an instance via converter", info.constructor, info.annotation);
                }
            }
            if (!info.hasKnownConversion() && info.factory == null && info.constructor == null && info.builder != null) {
                if (this.onlyBasicFeatures) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder pattern is not available with current analysis setup. Use annotation processor which supports such feature", info.builder.type, info.builder.annotation);
                } else if (this.requiresPublic(info.builder.type) && !info.builder.type.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder type: '" + info.builder.type + "' is not accessible", info.builder.build, info.builder.annotation);
                } else if (!this.types.isAssignable(info.builder.build.getReturnType(), info.element.asType())) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Wrong builder result type: '" + info.builder.build.getReturnType() + "'. Result must be assignable to '" + info.element.asType() + "'", info.builder.build, info.builder.annotation);
                } else if (!info.builder.build.getParameters().isEmpty()) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder method: '" + info.builder.build.getSimpleName() + "' can't have parameters", info.builder.build, info.builder.annotation);
                } else if (info.builder.ctor != null && info.builder.factory == null && !info.builder.ctor.getParameters().isEmpty()) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder constructor for: '" + info.builder.type + "' can't have parameters", info.builder.ctor, info.builder.annotation);
                } else if (info.builder.factory != null && !this.types.isSameType(info.builder.factory.getReturnType(), info.builder.type.asType())) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Wrong builder factory result type: '" + info.builder.build.getReturnType() + "'. Expecting: '" + info.builder.type + "'", info.builder.factory, info.builder.annotation);
                }
            }
            if (info.checkHashCollision()) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate hash value detected. Unable to create binding for: '" + className + "'. Remove (or reduce) alternativeNames from @JsonAttribute to resolve this issue." + info.pathDescription(), info.element, info.annotation);
            }
            if (info.deserializeAs != null) {
                StructInfo target = this.structs.get(((Object)info.deserializeAs.asType()).toString());
                info.setDeserializeTarget(target);
                if (target == null) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to find DSL-JSON metadata for: '" + info.deserializeAs.getQualifiedName() + "'. Add @CompiledJson annotation to target type.", info.element, info.annotation);
                }
            }
            if (info.deserializeAs == null && info.type == ObjectType.MIXIN) {
                HashSet<String> names = new HashSet<String>();
                String string = info.discriminator;
                if (string.length() > 0 && this.onlyBasicFeatures) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Custom $type discriminator is not supported with current analysis setup", info.element, info.annotation);
                }
                int invalidChartAt = -1;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c >= ' ' && c != '\"' && c != '\\' && c <= '~') continue;
                    invalidChartAt = i;
                    break;
                }
                if (invalidChartAt != -1) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Invalid discriminator value: '" + string + "' for mixin: " + className + ". Invalid char at: " + invalidChartAt, info.element, info.annotation);
                }
                for (StructInfo im : info.implementations) {
                    String actualName = im.deserializeName.isEmpty() ? im.element.getQualifiedName().toString() : im.deserializeName;
                    AttributeInfo attr = im.attributes.get(string);
                    if (attr != null) {
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Conflicting discriminator name detected: '" + string + "' for mixin: " + className + " with property '" + attr.name + "' in class " + im.element.toString(), info.element, info.annotation);
                    }
                    if (!names.add(actualName)) {
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate deserialization name detected: '" + actualName + "' for mixin: " + className, info.element, info.annotation);
                        continue;
                    }
                    if (!actualName.contains("\\") && !actualName.contains("\"")) continue;
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Invalid deserialization name (with quotes or escape chars) detected: '" + actualName + "' for mixin: " + className, info.element, info.annotation);
                }
            }
            if (info.type == ObjectType.MIXIN && info.discriminator.length() > 0 && info.implementations.isEmpty()) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "Custom discriminator found: '" + info.discriminator + "', but no implementation detected for mixin: " + className, info.element, info.annotation);
            }
            if (info.type == ObjectType.CLASS && info.discriminator.length() > 0) {
                if (info.attributes.containsKey(info.discriminator)) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Discriminator has the same value as one of the attributes. Discriminator will be excluded in favor of attribute value", info.element, info.annotation);
                }
                int hash = StructInfo.calcHash(info.discriminator);
                for (AttributeInfo attr : info.attributes.values()) {
                    boolean sameHash = StructInfo.calcHash(attr.id) == hash;
                    for (String name : attr.alternativeNames) {
                        sameHash = sameHash || StructInfo.calcHash(name) == hash;
                    }
                    if (!sameHash) continue;
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Discriminator has the same hash value as property: " + attr.name + ". Either simulate class discriminator via property, or remove the discriminator value from class", info.element, info.annotation);
                }
            }
            if (info.type == ObjectType.CLASS && this.onlyBasicFeatures && !info.hasKnownConversion() && !info.hasEmptyCtor()) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + className + "' requires public no argument constructor" + info.pathDescription(), info.element, info.annotation);
            } else if (!(info.type != ObjectType.CLASS || this.onlyBasicFeatures || info.hasEmptyCtor() || info.hasKnownConversion() || info.factory != null || info.builder != null || info.constructor != null && info.constructor.getParameters().size() == info.attributes.size())) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + className + "' does not have an empty or matching constructor" + info.pathDescription(), info.element, info.annotation);
            }
            if (info.formats.contains((Object)CompiledJson.Format.ARRAY)) {
                HashSet<Integer> ids = new HashSet<Integer>();
                for (AttributeInfo attr : info.attributes.values()) {
                    if (attr.index == -1 && info.canCreateEmptyInstance() && info.attributes.size() > 1) {
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "When array format is used on class with multiple properties all properties must have index order defined. Property " + attr.name + " doesn't have index defined", attr.element, attr.annotation);
                        continue;
                    }
                    if (attr.index == -1 || ids.add(attr.index)) continue;
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate index detected on " + attr.name + ". Index values must be distinct to be used in array format", attr.element, attr.annotation);
                }
            }
            if (info.isMinified) {
                info.prepareMinifiedNames();
            }
            info.sortAttributes();
        }
        return new LinkedHashMap<String, StructInfo>(this.structs);
    }

    private void findConverters(Element el) {
        AnnotationMirror dslAnn = this.getAnnotation(el, this.converterType);
        if (!(el instanceof TypeElement) || dslAnn == null) {
            return;
        }
        TypeElement converter = (TypeElement)el;
        DeclaredType target = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("target()")) continue;
            target = (DeclaredType)values.get(executableElement).getValue();
            break;
        }
        if (target == null) {
            return;
        }
        ConverterInfo signature = this.validateConverter(converter, target.asElement(), target.toString());
        if (!this.structs.containsKey(target.toString())) {
            String string = "struct" + this.structs.size();
            TypeElement element = (TypeElement)target.asElement();
            String binaryName = this.elements.getBinaryName(element).toString();
            StructInfo info = new StructInfo(signature, this.converterType, element, string, binaryName);
            this.structs.put(target.toString(), info);
        }
    }

    private ConverterInfo validateConverter(TypeElement converter, Element target, String fullName) {
        String allowed;
        VariableElement jsonReaderField = null;
        VariableElement jsonWriterField = null;
        ExecutableElement jsonReaderMethod = null;
        ExecutableElement jsonWriterMethod = null;
        boolean hasInstance = false;
        for (VariableElement field : ElementFilter.fieldsIn(converter.getEnclosedElements())) {
            if ("INSTANCE".equals(field.getSimpleName().toString())) {
                if (!((Object)field.asType()).toString().equals(converter.getQualifiedName().toString()) || !field.getModifiers().contains((Object)Modifier.STATIC) || !field.getModifiers().contains((Object)Modifier.PUBLIC) || !field.getModifiers().contains((Object)Modifier.FINAL)) continue;
                hasInstance = true;
                continue;
            }
            if ("JSON_READER".equals(field.getSimpleName().toString())) {
                jsonReaderField = field;
                continue;
            }
            if (!"JSON_WRITER".equals(field.getSimpleName().toString())) continue;
            jsonWriterField = field;
        }
        if (!this.onlyBasicFeatures) {
            for (ExecutableElement method : ElementFilter.methodsIn(converter.getEnclosedElements())) {
                if ("JSON_READER".equals(method.getSimpleName().toString()) || "getJSON_READER".equals(method.getSimpleName().toString())) {
                    jsonReaderMethod = method;
                    continue;
                }
                if (!"JSON_WRITER".equals(method.getSimpleName().toString()) && !"getJSON_WRITER".equals(method.getSimpleName().toString())) continue;
                jsonWriterMethod = method;
            }
        }
        String string = allowed = this.onlyBasicFeatures ? "field" : "field/method";
        if (!converter.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.asType() + "' must be public", converter, this.getAnnotation(converter, this.converterType));
        } else if (!target.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter target: '" + fullName + "' must be public", converter, this.getAnnotation(converter, this.converterType));
        } else if (converter.getNestingKind().isNested() && !converter.getModifiers().contains((Object)Modifier.STATIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.asType() + "' can't be a nested member. Only public static nested classes are supported", converter, this.getAnnotation(converter, this.converterType));
        } else if (this.onlyBasicFeatures && (converter.getQualifiedName().contentEquals(converter.getSimpleName()) || converter.getNestingKind().isNested() && converter.getModifiers().contains((Object)Modifier.STATIC) && converter.getEnclosingElement() instanceof TypeElement && ((TypeElement)converter.getEnclosingElement()).getQualifiedName().contentEquals(converter.getEnclosingElement().getSimpleName()))) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.getQualifiedName() + "' is defined without a package name and cannot be accessed", converter, this.getAnnotation(converter, this.converterType));
        } else if (jsonReaderField == null && jsonReaderMethod == null || jsonWriterField == null && jsonWriterMethod == null) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.getQualifiedName() + "' doesn't have a JSON_READER or JSON_WRITER " + allowed + ". It must have public static JSON_READER/JSON_WRITER " + allowed + " for conversion.", converter, this.getAnnotation(converter, this.converterType));
        } else if (!((jsonReaderMethod != null || jsonReaderField.getModifiers().contains((Object)Modifier.PUBLIC) && jsonReaderField.getModifiers().contains((Object)Modifier.STATIC)) && (jsonWriterMethod != null || jsonWriterField.getModifiers().contains((Object)Modifier.PUBLIC) && jsonWriterField.getModifiers().contains((Object)Modifier.STATIC)) && (jsonReaderMethod == null || jsonReaderMethod.getModifiers().contains((Object)Modifier.PUBLIC) && (hasInstance || jsonReaderMethod.getModifiers().contains((Object)Modifier.STATIC))) && (jsonWriterMethod == null || jsonWriterMethod.getModifiers().contains((Object)Modifier.PUBLIC) && (hasInstance || jsonWriterMethod.getModifiers().contains((Object)Modifier.STATIC))))) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.getQualifiedName() + "' doesn't have public and static JSON_READER and JSON_WRITER " + allowed + ". They must be public and static for converter to work properly.", converter, this.getAnnotation(converter, this.converterType));
        } else if (jsonReaderField != null && !("co.elastic.apm.agent.shaded.dslplatform.json.JsonReader.ReadObject<" + fullName + ">").equals(((Object)jsonReaderField.asType()).toString()) || jsonReaderMethod != null && !("co.elastic.apm.agent.shaded.dslplatform.json.JsonReader.ReadObject<" + fullName + ">").equals(((Object)jsonReaderMethod.getReturnType()).toString())) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.getQualifiedName() + "' has invalid type for JSON_READER field. It must be of type: 'com.dslplatform.json.JsonReader.ReadObject<" + fullName + ">'", converter, this.getAnnotation(converter, this.converterType));
        } else if (jsonWriterField != null && !("co.elastic.apm.agent.shaded.dslplatform.json.JsonWriter.WriteObject<" + fullName + ">").equals(((Object)jsonWriterField.asType()).toString()) || jsonWriterMethod != null && !("co.elastic.apm.agent.shaded.dslplatform.json.JsonWriter.WriteObject<" + fullName + ">").equals(((Object)jsonWriterMethod.getReturnType()).toString())) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.getQualifiedName() + "' has invalid type for JSON_WRITER " + allowed + ". It must be of type: 'com.dslplatform.json.JsonWriter.WriteObject<" + fullName + ">'", converter, this.getAnnotation(converter, this.converterType));
        }
        return new ConverterInfo(converter, jsonReaderMethod != null ? (hasInstance ? "INSTANCE." : "") + jsonReaderMethod.getSimpleName().toString() + "()" : (jsonReaderField != null ? jsonReaderField.getSimpleName().toString() : ""), jsonWriterMethod != null ? (hasInstance ? "INSTANCE." : "") + jsonWriterMethod.getSimpleName().toString() + "()" : (jsonWriterField != null ? jsonWriterField.getSimpleName().toString() : ""));
    }

    public List<TypeElement> getTypeHierarchy(TypeElement element) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        this.getAllTypes(element, result, new HashSet<TypeElement>());
        return result;
    }

    private void getAllTypes(TypeElement element, List<TypeElement> result, Set<TypeElement> processed) {
        if (!processed.add(element) || element.getQualifiedName().contentEquals("java.lang.Object")) {
            return;
        }
        result.add(element);
        for (TypeMirror typeMirror : this.types.directSupertypes(element.asType())) {
            Element current = this.types.asElement(typeMirror);
            if (!(current instanceof TypeElement)) continue;
            this.getAllTypes((TypeElement)current, result, processed);
        }
    }

    public void findRelatedReferences() {
        int total;
        do {
            total = this.structs.size();
            ArrayList<StructInfo> items = new ArrayList<StructInfo>(this.structs.values());
            Stack<String> path = new Stack<String>();
            for (StructInfo info : items) {
                if (info.hasKnownConversion()) continue;
                path.push(info.element.getSimpleName().toString());
                if (!this.onlyBasicFeatures && info.builder != null && info.constructor == null && info.factory == null) {
                    for (Map.Entry<String, AccessElements> p : this.getBuilderProperties(info.element, info.builder, this.includeBeanMethods, this.includeExactMethods, this.includeFields).entrySet()) {
                        AccessElements ae = p.getValue();
                        this.analyzeAttribute(info, ae.field != null ? ae.field.asType() : ae.read.getReturnType(), p.getKey(), ae, "builder property", path);
                    }
                } else {
                    if (this.includeBeanMethods) {
                        for (Map.Entry<String, AccessElements> p : this.getBeanProperties(info.element, info.constructor, info.factory).entrySet()) {
                            this.analyzeAttribute(info, p.getValue().read.getReturnType(), p.getKey(), p.getValue(), "bean property", path);
                        }
                    }
                    if (this.includeExactMethods) {
                        for (Map.Entry<String, AccessElements> p : this.getExactProperties(info.element, info.constructor, info.factory).entrySet()) {
                            if (info.attributes.containsKey(p.getKey()) && info.annotation == null) continue;
                            this.analyzeAttribute(info, p.getValue().read.getReturnType(), p.getKey(), p.getValue(), "exact property", path);
                        }
                    }
                    if (this.includeFields) {
                        for (Map.Entry<String, AccessElements> f : this.getPublicFields(info.element, this.onlyBasicFeatures, info.constructor, info.factory).entrySet()) {
                            if (info.attributes.containsKey(f.getKey()) && info.annotation == null) continue;
                            this.analyzeAttribute(info, f.getValue().field.asType(), f.getKey(), f.getValue(), "field", path);
                        }
                    }
                }
                path.pop();
            }
        } while (total != this.structs.size());
    }

    private Map<String, TypeMirror> findGenericSignatures(TypeMirror type) {
        ArrayDeque<? extends TypeMirror> queue = new ArrayDeque<TypeMirror>(this.types.directSupertypes(type));
        HashMap<String, TypeMirror> genericAttributes = new HashMap<String, TypeMirror>();
        while (!queue.isEmpty()) {
            DeclaredType declaredType;
            Element element;
            TypeMirror mirror = (TypeMirror)queue.poll();
            if (!(mirror instanceof DeclaredType) || !((element = (declaredType = (DeclaredType)mirror).asElement()) instanceof TypeElement)) continue;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            List<? extends TypeParameterElement> typeParameters = ((TypeElement)element).getTypeParameters();
            for (int i = 0; i < typeParameters.size(); ++i) {
                genericAttributes.put(typeParameters.get(i).toString(), typeArguments.get(i));
            }
            queue.addAll(this.types.directSupertypes(mirror));
        }
        return genericAttributes;
    }

    public static String objectName(String type) {
        return "int".equals(type) ? "java.lang.Integer" : ("long".equals(type) ? "java.lang.Long" : ("double".equals(type) ? "java.lang.Double" : ("float".equals(type) ? "java.lang.Float" : ("char".equals(type) ? "java.lang.Character" : ("byte".equals(type) ? "java.lang.Byte" : ("short".equals(type) ? "java.lang.Short" : ("boolean".equals(type) ? "java.lang.Boolean" : type)))))));
    }

    private void analyzeAttribute(StructInfo info, TypeMirror originalType, String name, AccessElements access, String target, Stack<String> path) {
        Element element = access.field != null ? access.field : access.read;
        path.push(name);
        if (!info.properties.contains(element) && !this.hasIgnoredAnnotation(element)) {
            AttributeInfo other;
            String[] alternativeNames;
            ConverterInfo converter;
            TypeMirror referenceType = access.field != null ? access.field.asType() : access.read.getReturnType();
            TypeMirror type = originalType.getKind() == TypeKind.TYPEVAR && info.genericSignatures.containsKey(((Object)originalType).toString()) ? info.genericSignatures.get(((Object)originalType).toString()) : originalType;
            Element referenceElement = this.types.asElement(referenceType);
            AnnotationMirror annotation = access.annotation;
            TypeMirror converterMirror = this.findConverter(annotation);
            if (converterMirror != null) {
                TypeElement typeConverter = this.elements.getTypeElement(((Object)converterMirror).toString());
                String javaType = ((Object)type).toString();
                String objectType = Analysis.objectName(javaType);
                Element declaredType = objectType.equals(javaType) ? this.types.asElement(type) : this.elements.getTypeElement(objectType);
                converter = this.validateConverter(typeConverter, declaredType, objectType);
            } else {
                converter = null;
            }
            String referenceName = ((Object)referenceType).toString();
            boolean isJsonObject = this.jsonObjectReaderPath(referenceElement, false) != null;
            boolean typeResolved = converter != null || isJsonObject || this.structs.containsKey(referenceName);
            boolean hasUnknown = false;
            boolean hasOwnerStructType = false;
            HashMap<String, Integer> typeVariablesIndex = new HashMap<String, Integer>();
            if (!typeResolved || info.isParameterized) {
                Map<String, PartKind> references = this.analyzeParts(referenceType);
                for (Map.Entry<String, PartKind> kv : references.entrySet()) {
                    String partTypeName = kv.getKey();
                    PartKind partKind = kv.getValue();
                    if (partKind == PartKind.UNKNOWN || partKind == PartKind.RAW_TYPE) {
                        hasUnknown = true;
                    }
                    if (partKind == PartKind.TYPE_VARIABLE) {
                        typeVariablesIndex.put(partTypeName, info.typeParametersNames.indexOf(partTypeName));
                    }
                    if (!partTypeName.equals(info.element.toString())) continue;
                    hasOwnerStructType = true;
                }
            }
            CompiledJson.TypeSignature typeSignature = this.typeSignatureValue(annotation);
            AttributeInfo attr = new AttributeInfo(name, access.read, access.write, access.field, type, annotation, this.hasNonNullable(element, annotation), this.hasMandatoryAnnotation(element, annotation), this.index(element, annotation), this.findNameAlias(element, annotation), this.isFullMatch(element, annotation), typeSignature, converter, isJsonObject, typeVariablesIndex, hasOwnerStructType);
            String[] stringArray = alternativeNames = attr.annotation == null ? null : this.getAlternativeNames(attr.annotation);
            if (alternativeNames != null) {
                attr.alternativeNames.addAll(Arrays.asList(alternativeNames));
            }
            if ((other = info.attributes.get(attr.id)) != null && (other.annotation != null && attr.annotation == null || other.annotation == null && attr.annotation == null && other.field == null && attr.field != null)) {
                path.pop();
                return;
            }
            if (other != null && (!other.name.equals(attr.name) || other.id.equals(attr.id) && other.field == null && attr.field == null)) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate alias detected on " + (attr.field != null ? "field: " : "property: ") + attr.name, attr.element, info.annotation);
            }
            if (!typeResolved && hasUnknown) {
                info.unknowns.put(attr.id, referenceType);
            }
            info.attributes.put(attr.id, attr);
            info.properties.add(attr.element);
            this.checkRelatedProperty(type, info.discoveredBy, target, info.element, element, path);
        }
        path.pop();
    }

    private void checkRelatedProperty(TypeMirror returnType, DeclaredType discoveredBy, String access, Element inside, Element property, Stack<String> path) {
        TypeMirror converter = this.findConverter(property);
        if (converter != null) {
            return;
        }
        this.checkRelatedPropertyRecursively(returnType, discoveredBy, access, inside, path);
    }

    private void checkRelatedPropertyRecursively(TypeMirror returnType, DeclaredType discoveredBy, String access, Element inside, Stack<String> path) {
        String typeName = ((Object)returnType).toString();
        if (this.structs.containsKey(typeName) || this.typeSupport.isSupported(typeName)) {
            return;
        }
        if (returnType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)returnType;
            String rawTypeName = declaredType.asElement().toString();
            if (!this.structs.containsKey(rawTypeName) && !this.typeSupport.isSupported(rawTypeName)) {
                Element el = declaredType.asElement();
                this.findStructs(el, discoveredBy, el + " is referenced as " + access + " from '" + inside.asType() + "' through CompiledJson annotation.", path, null, null);
            }
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                this.checkRelatedPropertyRecursively(typeMirror, discoveredBy, access, inside, path);
            }
        } else if (returnType.getKind() == TypeKind.ARRAY) {
            ArrayType at = (ArrayType)returnType;
            this.checkRelatedPropertyRecursively(at.getComponentType(), discoveredBy, access, inside, path);
        } else {
            TypeElement el = this.elements.getTypeElement(typeName);
            if (el != null) {
                this.findStructs(el, discoveredBy, el + " is referenced as " + access + " from '" + inside.asType() + "' through CompiledJson annotation.", path, null, null);
            }
        }
    }

    private boolean requiresPublic(Element element) {
        if (this.onlyBasicFeatures) {
            return true;
        }
        String name = ((Object)element.asType()).toString();
        if (name.startsWith("java.")) {
            return true;
        }
        PackageElement pkg = this.elements.getPackageOf(element);
        if (pkg == null) {
            return false;
        }
        Package packageClass = Package.getPackage(pkg.getQualifiedName().toString());
        return packageClass != null && packageClass.isSealed();
    }

    private void findStructs(Element el, DeclaredType discoveredBy, String errorMessge, Stack<String> path, @Nullable ExecutableElement factory, @Nullable ExecutableElement builder) {
        if (!(el instanceof TypeElement)) {
            return;
        }
        String typeName = el.toString();
        if (this.structs.containsKey(typeName) || this.typeSupport.isSupported(typeName) || "java.lang.Object".equals(typeName)) {
            return;
        }
        TypeElement element = (TypeElement)el;
        boolean isMixin = element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.CLASS && element.getModifiers().contains((Object)Modifier.ABSTRACT);
        String jsonObjectReaderPath = this.jsonObjectReaderPath(element, true);
        boolean isJsonObject = jsonObjectReaderPath != null;
        AnnotationMirror annotation = this.scanClassForAnnotation(element, discoveredBy, factory);
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", therefore '" + element.asType() + "' can't be private ", element, annotation);
        } else if (this.requiresPublic(element) && !element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", therefore '" + element.asType() + "' must be public ", element, annotation);
        } else if (element.getNestingKind().isNested() && !element.getModifiers().contains((Object)Modifier.STATIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", therefore '" + element.asType() + "' can't be a nested member. Only static nested classes are supported.", element, annotation);
        } else if (this.onlyBasicFeatures && (element.getQualifiedName().contentEquals(element.getSimpleName()) || element.getNestingKind().isNested() && element.getModifiers().contains((Object)Modifier.STATIC) && element.getEnclosingElement() instanceof TypeElement && ((TypeElement)element.getEnclosingElement()).getQualifiedName().contentEquals(element.getEnclosingElement().getSimpleName()))) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", but class '" + element.getQualifiedName() + "' is defined without a package name and cannot be accessed.", element, annotation);
        } else if (element.getNestingKind().isNested() && this.requiresPublic(element.getEnclosingElement()) && !element.getEnclosingElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", therefore '" + element.getEnclosingElement().asType() + "' must be public ", element, annotation);
        } else {
            CompiledJson.Format[] formats;
            ObjectType type = isMixin ? ObjectType.MIXIN : (element.getKind() == ElementKind.ENUM ? ObjectType.ENUM : ObjectType.CLASS);
            CompiledJson.Behavior onUnknown = CompiledJson.Behavior.DEFAULT;
            CompiledJson.TypeSignature typeSignature = CompiledJson.TypeSignature.DEFAULT;
            TypeElement deserializeAs = null;
            if (!isJsonObject) {
                if (annotation != null) {
                    onUnknown = this.onUnknownValue(annotation);
                    typeSignature = this.typeSignatureValue(annotation);
                    deserializeAs = Analysis.deserializeAs(annotation);
                    if (deserializeAs != null) {
                        String error = this.validateDeserializeAs(element, deserializeAs);
                        if (error != null) {
                            this.hasError = true;
                            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", but specified deserializeAs target: '" + deserializeAs.getQualifiedName() + "' " + error, element, annotation);
                            deserializeAs = null;
                        } else if (((Object)deserializeAs.asType()).toString().equals(((Object)element.asType()).toString())) {
                            deserializeAs = null;
                        } else {
                            this.findStructs(deserializeAs, discoveredBy, errorMessge, path, null, null);
                        }
                    }
                } else if (this.annotationUsage != AnnotationUsage.IMPLICIT) {
                    if (this.annotationUsage == AnnotationUsage.EXPLICIT) {
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Annotation usage is set to explicit, but '" + element.getQualifiedName() + "' is used implicitly through references. " + "Either change usage to implicit, use @Ignore on property referencing this type or register custom converter for problematic type. " + errorMessge, element);
                    } else if (element.getQualifiedName().toString().startsWith("java.")) {
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Annotation usage is set to non-java, but '" + element.getQualifiedName() + "' is found in java package. " + "Either change usage to implicit, use @Ignore on property referencing this type, register custom converter for problematic type or add annotation to this type. " + errorMessge, element);
                    }
                }
            }
            if (new HashSet<CompiledJson.Format>(Arrays.asList(formats = this.getFormats(annotation))).size() != formats.length) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate format detected on '" + element.getQualifiedName() + "'.", element, annotation);
            }
            String name = "struct" + this.structs.size();
            String binaryName = this.elements.getBinaryName(element).toString();
            BuilderInfo builderInfo = this.findBuilder(element, discoveredBy, builder);
            ExecutableElement factoryAnn = this.findAnnotatedFactory(element, discoveredBy, factory, builderInfo);
            StructInfo info = new StructInfo(element, discoveredBy, name, binaryName, type, jsonObjectReaderPath, this.findMatchingConstructors(element), this.findAnnotatedConstructor(element, discoveredBy), factoryAnn, builderInfo, annotation, onUnknown, typeSignature, deserializeAs, Analysis.classDiscriminator(annotation), Analysis.className(annotation), type == ObjectType.ENUM ? this.findEnumConstantNameSource(element) : null, this.isMinified(annotation), formats, this.findGenericSignatures(element.asType()));
            info.path.addAll(path);
            if (type == ObjectType.ENUM) {
                info.constants.addAll(Analysis.getEnumConstants(info.element));
            }
            this.structs.put(typeName, info);
        }
    }

    @Nullable
    private String validateDeserializeAs(TypeElement source, TypeElement target) {
        if (target.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return "can't be private";
        }
        if (this.requiresPublic(target) && !target.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return "must be public";
        }
        if (target.getNestingKind().isNested() && !target.getModifiers().contains((Object)Modifier.STATIC)) {
            return "can't be a nested member. Only public static nested classes are supported";
        }
        if (target.getNestingKind().isNested() && !target.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return "must be public when nested in another class";
        }
        if (this.onlyBasicFeatures && (target.getQualifiedName().contentEquals(target.getSimpleName()) || target.getNestingKind().isNested() && target.getModifiers().contains((Object)Modifier.STATIC) && target.getEnclosingElement() instanceof TypeElement && ((TypeElement)target.getEnclosingElement()).getQualifiedName().contentEquals(target.getEnclosingElement().getSimpleName()))) {
            return "is defined without a package name and cannot be accessed";
        }
        if (target.getKind() == ElementKind.INTERFACE || target.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return "must be a concrete type";
        }
        if (!((Object)source.asType()).toString().equals(((Object)target.asType()).toString()) && source.getKind() != ElementKind.INTERFACE && !source.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return "can only be specified for interfaces and abstract classes. '" + source + "' is neither interface nor abstract class";
        }
        if (!this.types.isAssignable(target.asType(), source.asType())) {
            return "is not assignable to '" + source.getQualifiedName() + "'";
        }
        return null;
    }

    @Nullable
    public List<ExecutableElement> findMatchingConstructors(Element element) {
        if (element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ENUM || element.getKind() == ElementKind.CLASS && element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return null;
        }
        ArrayList<ExecutableElement> matchingCtors = new ArrayList<ExecutableElement>();
        for (ExecutableElement constructor : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            if (constructor.getModifiers().contains((Object)Modifier.PRIVATE) || constructor.getModifiers().contains((Object)Modifier.PROTECTED) || this.requiresPublic(element) && !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            matchingCtors.add(constructor);
        }
        return matchingCtors;
    }

    @Nullable
    public ExecutableElement findAnnotatedConstructor(Element element, DeclaredType discoveredBy) {
        if (element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ENUM || element.getKind() == ElementKind.CLASS && element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return null;
        }
        for (ExecutableElement constructor : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            AnnotationMirror discAnn = this.getAnnotation(constructor, discoveredBy);
            if (discAnn != null) {
                if (constructor.getModifiers().contains((Object)Modifier.PRIVATE) || constructor.getModifiers().contains((Object)Modifier.PROTECTED) || this.requiresPublic(element) && !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Constructor in '" + element.asType() + "' is annotated with " + discoveredBy + ", but it's not accessible.", constructor, discAnn);
                }
                return constructor;
            }
            for (AnnotationMirror annotationMirror : constructor.getAnnotationMirrors()) {
                if (!this.alternativeCreators.contains(annotationMirror.getAnnotationType().toString())) continue;
                if (constructor.getModifiers().contains((Object)Modifier.PRIVATE) || constructor.getModifiers().contains((Object)Modifier.PROTECTED) || this.requiresPublic(element) && !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Constructor in '" + element.asType() + "' is annotated with " + annotationMirror.getAnnotationType() + ", but it's not public.", constructor, annotationMirror);
                }
                return constructor;
            }
        }
        return null;
    }

    @Nullable
    private ExecutableElement findAnnotatedFactory(Element element, DeclaredType discoveredBy, @Nullable ExecutableElement factory, @Nullable BuilderInfo builder) {
        if (element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ENUM) {
            return null;
        }
        AnnotationMirror annotation = null;
        if (factory == null) {
            block0: for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
                AnnotationMirror discAnn = this.getAnnotation(method, discoveredBy);
                if (discAnn != null) {
                    factory = method;
                    annotation = discAnn;
                    break;
                }
                for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
                    if (!this.alternativeCreators.contains(annotationMirror.getAnnotationType().toString()) || !method.getModifiers().contains((Object)Modifier.PRIVATE) && (!this.requiresPublic(element) || method.getModifiers().contains((Object)Modifier.PUBLIC))) continue;
                    factory = method;
                    annotation = annotationMirror;
                    continue block0;
                }
            }
        }
        if (factory == null) {
            return null;
        }
        boolean isStaticMethod = factory.getModifiers().contains((Object)Modifier.STATIC);
        boolean isSingletonInstanceMethod = false;
        TypeElement parent = (TypeElement)factory.getEnclosingElement();
        if (!isStaticMethod && parent.getEnclosingElement() instanceof TypeElement && parent.getModifiers().contains((Object)Modifier.STATIC)) {
            TypeElement grandparent = (TypeElement)parent.getEnclosingElement();
            for (VariableElement field : ElementFilter.fieldsIn(grandparent.getEnclosedElements())) {
                if (!((Object)field.getSimpleName()).equals(parent.getSimpleName()) || !field.getModifiers().contains((Object)Modifier.PUBLIC) || !field.getModifiers().contains((Object)Modifier.STATIC) || !field.getModifiers().contains((Object)Modifier.FINAL)) continue;
                isSingletonInstanceMethod = true;
                break;
            }
        }
        if (factory.getModifiers().contains((Object)Modifier.PRIVATE) || !isStaticMethod && !isSingletonInstanceMethod || this.requiresPublic(factory.getEnclosingElement()) && !factory.getModifiers().contains((Object)Modifier.PUBLIC)) {
            if (builder != null) {
                return null;
            }
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Factory method in '" + factory.getEnclosingElement().asType() + "' is annotated with " + discoveredBy + ", but it's not accessible.", factory, annotation != null ? annotation : this.getAnnotation(factory, discoveredBy));
        }
        return factory;
    }

    @Nullable
    private BuilderInfo findBuilder(Element element, DeclaredType discoveredBy, @Nullable ExecutableElement builder) {
        Element ee;
        if (element.getKind() == ElementKind.ENUM) {
            return null;
        }
        ExecutableElement factory = null;
        ExecutableElement build = builder;
        TypeElement builderType = null;
        if (builder != null && (ee = builder.getEnclosingElement()) instanceof TypeElement) {
            builderType = (TypeElement)ee;
        }
        for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
            Element nested;
            if (!method.getModifiers().contains((Object)Modifier.STATIC) || !method.getModifiers().contains((Object)Modifier.PUBLIC) || !((nested = this.types.asElement(method.getReturnType())) instanceof TypeElement) || !element.getEnclosedElements().contains(nested) || !method.getParameters().isEmpty() || builderType != null && !builderType.toString().equals(nested.toString())) continue;
            factory = method;
            builderType = (TypeElement)nested;
            break;
        }
        if (builderType == null) {
            return null;
        }
        if (build == null) {
            block1: for (TypeElement inheritance : this.getTypeHierarchy(builderType)) {
                for (ExecutableElement method : ElementFilter.methodsIn(inheritance.getEnclosedElements())) {
                    if (!method.getParameters().isEmpty() || method.getModifiers().contains((Object)Modifier.STATIC) || !this.types.isSameType(method.getReturnType(), element.asType())) continue;
                    build = method;
                    continue block1;
                }
            }
            if (build == null) {
                return null;
            }
        }
        AnnotationMirror annotation = this.getAnnotation(build, discoveredBy);
        List<ExecutableElement> ctors = this.findMatchingConstructors(builderType);
        ExecutableElement ctor = ctors != null && ctors.size() == 1 ? ctors.get(0) : null;
        return new BuilderInfo(factory, ctor, builderType, build, annotation);
    }

    private Map<String, PartKind> analyzeParts(TypeMirror target) {
        HashMap<String, PartKind> parts = new HashMap<String, PartKind>();
        this.analyzePartsRecursively(target, parts);
        return parts;
    }

    private void analyzePartsRecursively(TypeMirror target, Map<String, PartKind> parts) {
        String typeName = ((Object)target).toString();
        if (this.typeSupport.isSupported(typeName)) {
            if (this.isRawType(target)) {
                parts.put(typeName, PartKind.RAW_TYPE);
            } else {
                parts.put(typeName, PartKind.OTHER);
            }
            return;
        }
        switch (target.getKind()) {
            case ARRAY: {
                ArrayType at = (ArrayType)target;
                this.analyzePartsRecursively(at.getComponentType(), parts);
                break;
            }
            case DECLARED: {
                boolean knownAndValidStruct;
                DeclaredType declaredType = (DeclaredType)target;
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                String rawTypeName = declaredType.asElement().toString();
                StructInfo struct = this.structs.get(rawTypeName);
                boolean bl = knownAndValidStruct = struct != null && (struct.type != ObjectType.CLASS || struct.hasAnnotation() || !struct.attributes.isEmpty() || !struct.implementations.isEmpty() || struct.hasKnownConversion());
                if (knownAndValidStruct || this.typeSupport.isSupported(rawTypeName)) {
                    if (this.isRawType(target)) {
                        parts.put(rawTypeName, PartKind.RAW_TYPE);
                    } else {
                        parts.put(rawTypeName, PartKind.OTHER);
                    }
                } else {
                    parts.put(rawTypeName, PartKind.UNKNOWN);
                }
                for (TypeMirror typeMirror : typeArguments) {
                    this.analyzePartsRecursively(typeMirror, parts);
                }
                break;
            }
            case TYPEVAR: {
                parts.put(((Object)target).toString(), PartKind.TYPE_VARIABLE);
                break;
            }
            default: {
                parts.put(typeName, PartKind.UNKNOWN);
            }
        }
    }

    private boolean isRawType(TypeMirror target) {
        if (target.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)target;
            return declaredType.getTypeArguments().isEmpty() && !((TypeElement)declaredType.asElement()).getTypeParameters().isEmpty();
        }
        return false;
    }

    private static List<String> getEnumConstants(TypeElement element) {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.ENUM_CONSTANT) continue;
            result.add(element2.getSimpleName().toString());
        }
        return result;
    }

    @Nullable
    private Element findEnumConstantNameSource(TypeElement element) {
        Element nameSource = null;
        block3: for (Element element2 : element.getEnclosedElements()) {
            if (element2.getAnnotation(JsonValue.class) == null) continue;
            switch (element2.getKind()) {
                case FIELD: 
                case METHOD: {
                    if (nameSource == null) {
                        if (!element2.getModifiers().contains((Object)Modifier.PUBLIC)) {
                            this.printError((element2.getKind().isField() ? "Field '" : "Method '") + element2.toString() + "' annotated with @JsonValue must be public.", element2);
                            continue block3;
                        }
                        if (!this.isSupportedEnumNameType(element2)) {
                            this.printError((element2.getKind().isField() ? "Field '" : "Method '") + element2.toString() + "' annotated with @JsonValue must be of a supported type. Unknown types can be supported by enabling unknown types configuration option or whitelisting that specific unknown type", element2);
                            continue block3;
                        }
                        nameSource = element2;
                        continue block3;
                    }
                    this.printError("Duplicate @JsonValue annotation found. Only one enum field or getter can be annotated.", element2);
                    continue block3;
                }
            }
            this.printError("Unexpected @JsonValue annotation found. It must be placed on enum field or getter.", element2);
        }
        return nameSource;
    }

    private boolean isSupportedEnumNameType(Element element) {
        String enumNameType = this.extractReturnType(element);
        if (enumNameType == null) {
            return false;
        }
        if (this.typeSupport.isSupported(enumNameType) || this.unknownTypes == UnknownTypes.ALLOW) {
            return true;
        }
        StructInfo target = this.structs.get(enumNameType);
        if (target != null && target.hasKnownConversion()) {
            return true;
        }
        if (this.unknownTypes == UnknownTypes.WARNING) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, (element.getKind().isField() ? "Field '" : "Method '") + element.toString() + "' annotated with @JsonValue is of unknown type.", element);
            return true;
        }
        return false;
    }

    @Nullable
    private String extractReturnType(Element element) {
        switch (element.getKind()) {
            case FIELD: {
                return ((Object)element.asType()).toString();
            }
            case METHOD: {
                return ((Object)((ExecutableElement)element).getReturnType()).toString();
            }
        }
        return null;
    }

    private void printError(String message, Element element) {
        this.hasError = true;
        this.messager.printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private String jsonObjectReaderPath(Element el, boolean includeErrors) {
        void var6_8;
        String used;
        if (!(el instanceof TypeElement)) {
            return null;
        }
        TypeElement element = (TypeElement)el;
        boolean isJsonObject = false;
        for (TypeMirror typeMirror : element.getInterfaces()) {
            if (!JsonObject.class.getName().equals(((Object)typeMirror).toString())) continue;
            isJsonObject = true;
            break;
        }
        if (!isJsonObject) {
            return null;
        }
        VariableElement jsonReaderField = null;
        Object var6_7 = null;
        Element companion = null;
        for (VariableElement field : ElementFilter.fieldsIn(el.getEnclosedElements())) {
            if ("Companion".equals(field.getSimpleName().toString())) {
                if (!((Object)field.asType()).toString().equals(((Object)el.asType()).toString() + ".Companion") || !field.getModifiers().contains((Object)Modifier.STATIC) || !field.getModifiers().contains((Object)Modifier.PUBLIC) || !field.getModifiers().contains((Object)Modifier.FINAL)) continue;
                companion = this.types.asElement(field.asType());
                continue;
            }
            if (!"JSON_READER".equals(field.getSimpleName().toString())) continue;
            jsonReaderField = field;
        }
        String signatureType = "co.elastic.apm.agent.shaded.dslplatform.json.JsonReader.ReadJsonObject<" + element.getQualifiedName() + ">";
        if (!this.onlyBasicFeatures && companion != null && companion.getModifiers().contains((Object)Modifier.STATIC)) {
            for (ExecutableElement method : ElementFilter.methodsIn(companion.getEnclosedElements())) {
                if (!"JSON_READER".equals(method.getSimpleName().toString()) && !"getJSON_READER".equals(method.getSimpleName().toString())) continue;
                ExecutableElement executableElement = method;
            }
        }
        String string = used = var6_8 != null ? var6_8.getSimpleName() + " method" : "JSON_READER field";
        if (includeErrors) {
            if (!el.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + element.getQualifiedName() + "' is 'com.dslplatform.json.JsonObject', but it's not public. " + "Make it public so it can be used for serialization/deserialization.", el, this.getAnnotation(el, this.converterType));
            } else if (element.getNestingKind().isNested() && !el.getModifiers().contains((Object)Modifier.STATIC)) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + element.getQualifiedName() + "' is 'com.dslplatform.json.JsonObject', but it cant be non static nested member. " + "Add static modifier so it can be used for serialization/deserialization.", el, this.getAnnotation(el, this.converterType));
            } else if (this.onlyBasicFeatures && (element.getQualifiedName().contentEquals(element.getSimpleName()) || element.getNestingKind().isNested() && element.getModifiers().contains((Object)Modifier.STATIC) && element.getEnclosingElement() instanceof TypeElement && ((TypeElement)element.getEnclosingElement()).getQualifiedName().contentEquals(element.getEnclosingElement().getSimpleName()))) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + element.getQualifiedName() + "' is 'com.dslplatform.json.JsonObject', but its defined without a package name and cannot be accessed. " + "Either add package to it or use a different analysis configuration which support classes without packages.", element, this.getAnnotation(element, this.converterType));
            } else if (jsonReaderField == null && var6_8 == null) {
                String allowed = this.onlyBasicFeatures ? "field" : "field/method";
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + element.getQualifiedName() + "' is 'com.dslplatform.json.JsonObject', but it doesn't have JSON_READER " + allowed + ". " + "It can't be used for serialization/deserialization this way. " + "You probably want to add public static JSON_READER " + allowed + ".", element, this.getAnnotation(element, this.converterType));
            } else if (var6_8 == null && (!jsonReaderField.getModifiers().contains((Object)Modifier.PUBLIC) || !jsonReaderField.getModifiers().contains((Object)Modifier.STATIC)) || var6_8 != null && (!var6_8.getModifiers().contains((Object)Modifier.PUBLIC) || var6_8.getModifiers().contains((Object)Modifier.STATIC))) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + element.getQualifiedName() + "' is 'com.dslplatform.json.JsonObject', but its " + used + " is not public and static. " + "It can't be used for serialization/deserialization this way. " + "You probably want to change " + used + " so it's public and static.", element, this.getAnnotation(element, this.converterType));
            } else if (jsonReaderField != null && !signatureType.equals(((Object)jsonReaderField.asType()).toString()) || var6_8 != null && !signatureType.equals(((Object)var6_8.getReturnType()).toString())) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + element.getQualifiedName() + "' is 'com.dslplatform.json.JsonObject', but its " + used + " is not of correct type. " + "It can't be used for serialization/deserialization this way. " + "You probably want to change " + used + " to: '" + signatureType + "'", element, this.getAnnotation(element, this.converterType));
            }
        }
        String prefix = companion == null ? "" : "Companion.";
        return prefix + (var6_8 != null ? var6_8.getSimpleName().toString() + "()" : "JSON_READER");
    }

    private Map<String, VariableElement> getArguments(@Nullable ExecutableElement element) {
        if (element == null) {
            return Collections.emptyMap();
        }
        HashMap<String, VariableElement> arguments = new HashMap<String, VariableElement>();
        for (VariableElement variableElement : element.getParameters()) {
            arguments.put(variableElement.getSimpleName().toString(), variableElement);
        }
        return arguments;
    }

    private boolean isCompatibileType(TypeMirror left, TypeMirror right) {
        String rightStr;
        if (((Object)left).equals(right)) {
            return true;
        }
        String leftStr = ((Object)left).toString();
        if (leftStr.equals(rightStr = ((Object)right).toString())) {
            return true;
        }
        int ind = leftStr.indexOf(60);
        if (ind == -1 || rightStr.indexOf(60) != ind) {
            return false;
        }
        if (left.getKind() != right.getKind()) {
            return false;
        }
        if (!leftStr.substring(0, ind).equals(rightStr.substring(0, ind))) {
            return false;
        }
        return this.types.isAssignable(right, left);
    }

    public Map<String, AccessElements> getBeanProperties(TypeElement element, ExecutableElement ctor, @Nullable ExecutableElement factory) {
        HashMap<String, ExecutableElement> setters = new HashMap<String, ExecutableElement>();
        HashMap<String, ExecutableElement> getters = new HashMap<String, ExecutableElement>();
        Map<String, VariableElement> arguments = this.getArguments(factory != null ? factory : ctor);
        for (TypeElement inheritance : this.getTypeHierarchy(element)) {
            boolean isPublicInterface = inheritance.getKind() == ElementKind.INTERFACE && inheritance.getModifiers().contains((Object)Modifier.PUBLIC);
            for (ExecutableElement method : ElementFilter.methodsIn(inheritance.getEnclosedElements())) {
                String property;
                boolean isAccessible;
                String name = method.getSimpleName().toString();
                boolean bl = isAccessible = isPublicInterface && !method.getModifiers().contains((Object)Modifier.PRIVATE) || method.getModifiers().contains((Object)Modifier.PUBLIC) && !method.getModifiers().contains((Object)Modifier.STATIC) && !method.getModifiers().contains((Object)Modifier.NATIVE) && !method.getModifiers().contains((Object)Modifier.TRANSIENT) && !method.getModifiers().contains((Object)Modifier.ABSTRACT);
                if (name.length() < 4 || !isAccessible) continue;
                String string = property = name.substring(3).toUpperCase().equals(name.substring(3)) && name.length() > 4 ? name.substring(3) : name.substring(3, 4).toLowerCase() + name.substring(4);
                if (name.startsWith("get") && method.getParameters().size() == 0 && method.getReturnType() != null) {
                    if (getters.containsKey(property)) continue;
                    getters.put(property, method);
                    continue;
                }
                if (!name.startsWith("set") || method.getParameters().size() != 1) continue;
                setters.put(property, method);
            }
        }
        HashMap<String, AccessElements> result = new HashMap<String, AccessElements>();
        for (Map.Entry kv : getters.entrySet()) {
            ExecutableElement setter = (ExecutableElement)setters.get(kv.getKey());
            VariableElement setterArgument = setter == null ? null : setter.getParameters().get(0);
            VariableElement arg = arguments.get(kv.getKey());
            String returnType = ((Object)((ExecutableElement)kv.getValue()).getReturnType()).toString();
            AnnotationMirror annotation = this.annotation((ExecutableElement)kv.getValue(), setter, null, arg);
            if (setterArgument != null && ((Object)setterArgument.asType()).toString().equals(returnType)) {
                result.put((String)kv.getKey(), AccessElements.readWrite((ExecutableElement)kv.getValue(), setter, annotation));
                continue;
            }
            if (setterArgument != null && (setterArgument.asType() + "<").startsWith(returnType)) {
                result.put((String)kv.getKey(), AccessElements.readWrite((ExecutableElement)kv.getValue(), setter, annotation));
                continue;
            }
            if (this.onlyBasicFeatures || arg == null || !this.isCompatibileType(arg.asType(), ((ExecutableElement)kv.getValue()).getReturnType())) continue;
            result.put((String)kv.getKey(), AccessElements.readOnly((ExecutableElement)kv.getValue(), arg, annotation));
        }
        return result;
    }

    public Map<String, AccessElements> getExactProperties(TypeElement element, ExecutableElement ctor, @Nullable ExecutableElement factory) {
        HashMap<String, ExecutableElement> setters = new HashMap<String, ExecutableElement>();
        HashMap<String, ExecutableElement> getters = new HashMap<String, ExecutableElement>();
        Map<String, VariableElement> arguments = this.getArguments(factory != null ? factory : ctor);
        for (TypeElement inheritance : this.getTypeHierarchy(element)) {
            boolean isPublicInterface = inheritance.getKind() == ElementKind.INTERFACE && inheritance.getModifiers().contains((Object)Modifier.PUBLIC);
            for (ExecutableElement method : ElementFilter.methodsIn(inheritance.getEnclosedElements())) {
                boolean isAccessible;
                String name = method.getSimpleName().toString();
                boolean bl = isAccessible = isPublicInterface && !method.getModifiers().contains((Object)Modifier.PRIVATE) || method.getModifiers().contains((Object)Modifier.PUBLIC) && !method.getModifiers().contains((Object)Modifier.STATIC) && !method.getModifiers().contains((Object)Modifier.NATIVE) && !method.getModifiers().contains((Object)Modifier.TRANSIENT) && !method.getModifiers().contains((Object)Modifier.ABSTRACT);
                if (name.startsWith("get") || name.startsWith("set") || !isAccessible) continue;
                if (method.getParameters().size() == 0 && method.getReturnType() != null) {
                    if (getters.containsKey(name)) continue;
                    getters.put(name, method);
                    continue;
                }
                if (method.getParameters().size() != 1) continue;
                setters.put(name, method);
            }
        }
        HashMap<String, AccessElements> result = new HashMap<String, AccessElements>();
        for (Map.Entry kv : getters.entrySet()) {
            ExecutableElement setter = (ExecutableElement)setters.get(kv.getKey());
            VariableElement setterArgument = setter == null ? null : setter.getParameters().get(0);
            VariableElement arg = arguments.get(kv.getKey());
            String returnType = ((Object)((ExecutableElement)kv.getValue()).getReturnType()).toString();
            AnnotationMirror annotation = this.annotation((ExecutableElement)kv.getValue(), setter, null, arg);
            if (setterArgument != null && ((Object)setterArgument.asType()).toString().equals(returnType)) {
                result.put((String)kv.getKey(), AccessElements.readWrite((ExecutableElement)kv.getValue(), setter, annotation));
                continue;
            }
            if (setterArgument != null && (setterArgument.asType() + "<").startsWith(returnType)) {
                result.put((String)kv.getKey(), AccessElements.readWrite((ExecutableElement)kv.getValue(), setter, annotation));
                continue;
            }
            if (this.onlyBasicFeatures || arg == null || !this.isCompatibileType(arg.asType(), ((ExecutableElement)kv.getValue()).getReturnType())) continue;
            result.put((String)kv.getKey(), AccessElements.readOnly((ExecutableElement)kv.getValue(), arg, annotation));
        }
        return result;
    }

    public Map<String, AccessElements> getPublicFields(TypeElement element, boolean mustHaveEmptyCtor, ExecutableElement ctor, @Nullable ExecutableElement factory) {
        HashMap<String, AccessElements> result = new HashMap<String, AccessElements>();
        Map<String, VariableElement> arguments = this.getArguments(factory != null ? factory : ctor);
        for (TypeElement inheritance : this.getTypeHierarchy(element)) {
            for (VariableElement field : ElementFilter.fieldsIn(inheritance.getEnclosedElements())) {
                boolean isAccessible;
                String name = field.getSimpleName().toString();
                boolean isFinal = field.getModifiers().contains((Object)Modifier.FINAL);
                boolean bl = isAccessible = field.getModifiers().contains((Object)Modifier.PUBLIC) && (!isFinal || !mustHaveEmptyCtor) && !field.getModifiers().contains((Object)Modifier.NATIVE) && !field.getModifiers().contains((Object)Modifier.TRANSIENT) && !field.getModifiers().contains((Object)Modifier.STATIC);
                if (!isAccessible) continue;
                VariableElement arg = arguments.get(name);
                AnnotationMirror annotation = this.annotation(null, null, field, arg);
                result.put(name, AccessElements.field(field, arg, annotation));
            }
        }
        return result;
    }

    public Map<String, AccessElements> getBuilderProperties(TypeElement element, BuilderInfo builder, boolean withBeans, boolean withExact, boolean withFields) {
        VariableElement setArg;
        ExecutableElement setter;
        HashMap<String, ExecutableElement> setters = new HashMap<String, ExecutableElement>();
        HashMap<String, ExecutableElement> getters = new HashMap<String, ExecutableElement>();
        HashMap<String, VariableElement> fields = new HashMap<String, VariableElement>();
        TypeMirror builderType = builder.type.asType();
        for (TypeElement inheritance : this.getTypeHierarchy(element)) {
            String name;
            boolean isPublicInterface = inheritance.getKind() == ElementKind.INTERFACE && inheritance.getModifiers().contains((Object)Modifier.PUBLIC);
            for (ExecutableElement method : ElementFilter.methodsIn(inheritance.getEnclosedElements())) {
                boolean canAdd;
                String property;
                name = method.getSimpleName().toString();
                boolean isAccessible = isPublicInterface && !method.getModifiers().contains((Object)Modifier.PRIVATE) || method.getModifiers().contains((Object)Modifier.PUBLIC) && !method.getModifiers().contains((Object)Modifier.STATIC) && !method.getModifiers().contains((Object)Modifier.NATIVE) && !method.getModifiers().contains((Object)Modifier.TRANSIENT);
                if (!isAccessible) continue;
                String string = name.length() < 4 || !name.startsWith("get") ? name : (property = name.length() > 4 && name.substring(3).toUpperCase().equals(name.substring(3)) ? name.substring(3) : name.substring(3, 4).toLowerCase() + name.substring(4));
                if (method.getParameters().size() != 0 || method.getReturnType() == null || !(canAdd = withExact || withBeans && name.startsWith("get") && name.length() > 4) || getters.containsKey(property)) continue;
                getters.put(property, method);
            }
            if (!withFields) continue;
            for (VariableElement field : ElementFilter.fieldsIn(inheritance.getEnclosedElements())) {
                name = field.getSimpleName().toString();
                boolean isFinal = field.getModifiers().contains((Object)Modifier.FINAL);
                boolean isAccessible = field.getModifiers().contains((Object)Modifier.PUBLIC) && !field.getModifiers().contains((Object)Modifier.NATIVE) && !field.getModifiers().contains((Object)Modifier.TRANSIENT) && !field.getModifiers().contains((Object)Modifier.STATIC);
                if (!isAccessible || !isFinal) continue;
                fields.put(name, field);
            }
        }
        for (TypeElement inheritance : this.getTypeHierarchy(builder.type)) {
            for (ExecutableElement method : ElementFilter.methodsIn(inheritance.getEnclosedElements())) {
                boolean canAdd;
                String property;
                String name = method.getSimpleName().toString();
                boolean isAccessible = !method.getModifiers().contains((Object)Modifier.PRIVATE) || method.getModifiers().contains((Object)Modifier.PUBLIC) && !method.getModifiers().contains((Object)Modifier.STATIC) && !method.getModifiers().contains((Object)Modifier.NATIVE) && !method.getModifiers().contains((Object)Modifier.TRANSIENT);
                if (!isAccessible) continue;
                String string = name.length() < 4 || !name.startsWith("set") ? name : (property = name.length() > 4 && name.substring(3).toUpperCase().equals(name.substring(3)) ? name.substring(3) : name.substring(3, 4).toLowerCase() + name.substring(4));
                if (method.getParameters().size() != 1 || !this.types.isSameType(method.getReturnType(), builderType) || !(canAdd = withExact || withBeans && name.startsWith("set") && name.length() > 4) || setters.containsKey(property)) continue;
                setters.put(property, method);
            }
        }
        HashMap<String, AccessElements> result = new HashMap<String, AccessElements>();
        for (Map.Entry kv : getters.entrySet()) {
            setter = (ExecutableElement)setters.get(kv.getKey());
            setArg = setter == null ? null : setter.getParameters().get(0);
            String returnType = ((Object)((ExecutableElement)kv.getValue()).getReturnType()).toString();
            AnnotationMirror annotation = this.annotation((ExecutableElement)kv.getValue(), setter, null, null);
            if (setArg == null || !((Object)setArg.asType()).toString().equals(returnType) && !(setArg.asType() + "<").startsWith(returnType)) continue;
            result.put((String)kv.getKey(), AccessElements.readWrite((ExecutableElement)kv.getValue(), setter, annotation));
        }
        for (Map.Entry kv : fields.entrySet()) {
            if (result.containsKey(kv.getKey())) continue;
            setter = (ExecutableElement)setters.get(kv.getKey());
            setArg = setter == null ? null : setter.getParameters().get(0);
            String returnType = ((Object)((VariableElement)kv.getValue()).asType()).toString();
            AnnotationMirror annotation = this.annotation(null, setter, (VariableElement)kv.getValue(), null);
            if (setArg == null || !((Object)setArg.asType()).toString().equals(returnType) && !(setArg.asType() + "<").startsWith(returnType)) continue;
            result.put((String)kv.getKey(), AccessElements.readOnly((VariableElement)kv.getValue(), setter, annotation));
        }
        return result;
    }

    public void findImplementations(Collection<StructInfo> structs) {
        for (StructInfo current : structs) {
            if (current.type != ObjectType.MIXIN) continue;
            String signature = ((Object)current.element.asType()).toString();
            for (StructInfo info : structs) {
                if (info.type != ObjectType.CLASS) continue;
                this.checkParentSignatures(info, info.element, current.implementations, signature, new HashSet<TypeElement>());
            }
        }
    }

    private void checkParentSignatures(StructInfo info, TypeElement element, Set<StructInfo> implementations, String signature, Set<TypeElement> processed) {
        if (!processed.add(element) || element.getQualifiedName().contentEquals("java.lang.Object")) {
            return;
        }
        if (((Object)element.asType()).toString().equals(signature)) {
            implementations.add(info);
        }
        for (TypeMirror typeMirror : this.types.directSupertypes(element.asType())) {
            Element current = this.types.asElement(typeMirror);
            if (!(current instanceof TypeElement)) continue;
            this.checkParentSignatures(info, (TypeElement)current, implementations, signature, processed);
        }
    }

    @Nullable
    private String[] getAlternativeNames(AnnotationMirror dslAnn) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> ee : values.entrySet()) {
            if (!ee.getKey().toString().equals("alternativeNames()")) continue;
            List val = (List)ee.getValue().getValue();
            if (val == null) {
                return null;
            }
            String[] names = new String[val.size()];
            for (int i = 0; i < val.size(); ++i) {
                names[i] = ((AnnotationValue)val.get(i)).getValue().toString();
            }
            return names;
        }
        return null;
    }

    public boolean isFullMatch(Element property, @Nullable AnnotationMirror dslAnn) {
        if (dslAnn == null) {
            return false;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("hashMatch()")) continue;
            Object val = values.get(executableElement).getValue();
            return val != null && (Boolean)val == false;
        }
        return false;
    }

    public int index(Element property, @Nullable AnnotationMirror dslAnn) {
        if (dslAnn != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.toString().equals("index()")) continue;
                Object val = values.get(executableElement).getValue();
                if (val == null) {
                    return -1;
                }
                return (Integer)val;
            }
        }
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            Integer n = Analysis.matchCustomInteger(annotationMirror, this.alternativeIndex);
            if (n == null || n == -1) continue;
            return n;
        }
        return -1;
    }

    @Nullable
    private AnnotationMirror annotation(@Nullable ExecutableElement read, @Nullable ExecutableElement write, @Nullable VariableElement field, @Nullable VariableElement arg) {
        AnnotationMirror dslAnn;
        AnnotationMirror annotationMirror = dslAnn = read == null ? null : this.getAnnotation(read, this.attributeType);
        if (dslAnn != null) {
            return dslAnn;
        }
        AnnotationMirror annotationMirror2 = dslAnn = write == null ? null : this.getAnnotation(write, this.attributeType);
        if (dslAnn != null) {
            return dslAnn;
        }
        AnnotationMirror annotationMirror3 = dslAnn = field == null ? null : this.getAnnotation(field, this.attributeType);
        if (dslAnn != null) {
            return dslAnn;
        }
        return arg == null ? null : this.getAnnotation(arg, this.attributeType);
    }

    public boolean hasIgnoredAnnotation(Element property) {
        AnnotationMirror dslAnn = this.getAnnotation(property, this.attributeType);
        if (dslAnn != null) {
            return Analysis.booleanAnnotationValue(dslAnn, "ignore()", false);
        }
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            if (!this.alternativeIgnore.contains(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private AnnotationMirror scanClassForAnnotation(TypeElement element, DeclaredType annotationType, @Nullable ExecutableElement custom) {
        AnnotationMirror discAnn;
        AnnotationMirror target;
        AnnotationMirror annotationMirror = target = custom != null ? this.getAnnotation(custom, annotationType) : null;
        if (target != null) {
            return target;
        }
        target = this.getAnnotation(element, annotationType);
        if (target != null) {
            return target;
        }
        for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
            discAnn = this.getAnnotation(method, annotationType);
            if (discAnn == null) continue;
            return discAnn;
        }
        for (ExecutableElement constructor : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            discAnn = this.getAnnotation(constructor, annotationType);
            if (discAnn == null) continue;
            return discAnn;
        }
        return null;
    }

    @Nullable
    public AnnotationMirror getAnnotation(Element element, DeclaredType annotationType) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.types.isSameType(annotationMirror.getAnnotationType(), annotationType)) continue;
            return annotationMirror;
        }
        return null;
    }

    public boolean hasNonNullable(Element property, @Nullable AnnotationMirror dslAnn) {
        if (dslAnn != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.toString().equals("nullable()")) continue;
                Object val = values.get(executableElement).getValue();
                return val != null && (Boolean)val == false;
            }
            return false;
        }
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            Boolean bl = Analysis.matchCustomBoolean(annotationMirror, this.alternativeNonNullable);
            if (bl == null) continue;
            return bl;
        }
        return false;
    }

    @Nullable
    public static TypeElement deserializeAs(AnnotationMirror annotation) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("deserializeAs()")) continue;
            DeclaredType target = (DeclaredType)values.get(executableElement).getValue();
            return (TypeElement)target.asElement();
        }
        return null;
    }

    public static String classDiscriminator(@Nullable AnnotationMirror annotation) {
        if (annotation == null) {
            return "";
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("discriminator()") && !executableElement.toString().equals("deserializeDiscriminator()")) continue;
            return values.get(executableElement).getValue().toString();
        }
        return "";
    }

    public static String className(@Nullable AnnotationMirror annotation) {
        if (annotation == null) {
            return "";
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("name()") && !executableElement.toString().equals("deserializeName()")) continue;
            return values.get(executableElement).getValue().toString();
        }
        return "";
    }

    public boolean hasMandatoryAnnotation(Element property, @Nullable AnnotationMirror dslAnn) {
        if (dslAnn != null) {
            return Analysis.booleanAnnotationValue(dslAnn, "mandatory()", false);
        }
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            Boolean match = Analysis.matchCustomBoolean(annotationMirror, this.alternativeMandatory);
            if (match == null) continue;
            return match;
        }
        return false;
    }

    public static boolean booleanAnnotationValue(AnnotationMirror ann, String method, boolean defaultValue) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = ann.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals(method)) continue;
            Object val = values.get(executableElement).getValue();
            return val == null ? defaultValue : (Boolean)val;
        }
        return defaultValue;
    }

    @Nullable
    public CompiledJson.Behavior onUnknownValue(@Nullable AnnotationMirror annotation) {
        if (annotation == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("onUnknown()")) continue;
            Object val = values.get(executableElement).getValue();
            if (val == null) {
                return null;
            }
            return CompiledJson.Behavior.valueOf(val.toString());
        }
        return null;
    }

    @Nullable
    public CompiledJson.TypeSignature typeSignatureValue(@Nullable AnnotationMirror annotation) {
        if (annotation == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("typeSignature()")) continue;
            Object val = values.get(executableElement).getValue();
            if (val == null) {
                return null;
            }
            return CompiledJson.TypeSignature.valueOf(val.toString());
        }
        return null;
    }

    public CompiledJson.Format[] getFormats(@Nullable AnnotationMirror ann) {
        if (ann == null) {
            return new CompiledJson.Format[]{CompiledJson.Format.OBJECT};
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = ann.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!"formats()".equals(executableElement.toString())) continue;
            Object val = values.get(executableElement).getValue();
            if (val == null) {
                return new CompiledJson.Format[]{CompiledJson.Format.OBJECT};
            }
            List list = (List)val;
            CompiledJson.Format[] result = new CompiledJson.Format[list.size()];
            for (int i = 0; i < result.length; ++i) {
                AnnotationValue enumVal = (AnnotationValue)list.get(i);
                result[i] = CompiledJson.Format.valueOf(enumVal.getValue().toString());
            }
            return result;
        }
        return new CompiledJson.Format[]{CompiledJson.Format.OBJECT};
    }

    public boolean isMinified(@Nullable AnnotationMirror ann) {
        if (ann == null) {
            return false;
        }
        for (ExecutableElement executableElement : ann.getElementValues().keySet()) {
            if (!"minified()".equals(executableElement.toString())) continue;
            AnnotationValue minified = ann.getElementValues().get(executableElement);
            return (Boolean)minified.getValue();
        }
        return false;
    }

    @Nullable
    public TypeMirror findConverter(Element property) {
        return this.findConverter(this.getAnnotation(property, this.attributeType));
    }

    @Nullable
    private TypeMirror findConverter(@Nullable AnnotationMirror dslAnn) {
        if (dslAnn == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("converter()")) continue;
            TypeMirror mirror = (TypeMirror)values.get(executableElement).getValue();
            return mirror != null && ((Object)mirror).toString().equals(JsonAttribute.class.getName()) ? null : mirror;
        }
        return null;
    }

    @Nullable
    public String findNameAlias(Element property, @Nullable AnnotationMirror dslAnn) {
        if (dslAnn != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.toString().equals("name()")) continue;
                String val = (String)values.get(executableElement).getValue();
                if (val != null && val.length() == 0) {
                    return null;
                }
                return val;
            }
            return null;
        }
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            String string = Analysis.matchCustomString(annotationMirror, this.alternativeAlias);
            if (string == null || string.isEmpty()) continue;
            return string;
        }
        return null;
    }

    @Nullable
    private static Boolean matchCustomBoolean(AnnotationMirror ann, Map<String, List<AnnotationMapping<Boolean>>> alternatives) {
        String name = ann.getAnnotationType().toString();
        if (alternatives.containsKey(name)) {
            List<AnnotationMapping<Boolean>> mappings = alternatives.get(name);
            if (mappings == null || mappings.isEmpty()) {
                return true;
            }
            for (AnnotationMapping<Boolean> m : mappings) {
                Map<? extends ExecutableElement, ? extends AnnotationValue> values = ann.getElementValues();
                for (ExecutableElement executableElement : values.keySet()) {
                    if (!executableElement.toString().equals(m.name)) continue;
                    Object val = values.get(executableElement).getValue();
                    if (val == null && m.value == null) {
                        return true;
                    }
                    return val != null && val == m.value;
                }
            }
        }
        return null;
    }

    @Nullable
    private static String matchCustomString(AnnotationMirror ann, Map<String, String> alternatives) {
        String value = alternatives.get(ann.getAnnotationType().toString());
        if (value != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = ann.getElementValues();
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.toString().equals(value)) continue;
                AnnotationValue val = values.get(executableElement);
                if (val == null) {
                    return null;
                }
                if (val.getValue() == null) {
                    return null;
                }
                return val.getValue().toString();
            }
        }
        return null;
    }

    @Nullable
    private static Integer matchCustomInteger(AnnotationMirror ann, Map<String, String> alternatives) {
        String value = alternatives.get(ann.getAnnotationType().toString());
        if (value != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = ann.getElementValues();
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.toString().equals(value)) continue;
                AnnotationValue val = values.get(executableElement);
                if (val == null) {
                    return null;
                }
                if (val.getValue() == null) {
                    return null;
                }
                return (Integer)val.getValue();
            }
        }
        return null;
    }

    public static class AccessElements {
        public final ExecutableElement read;
        public final ExecutableElement write;
        public final VariableElement field;
        public final VariableElement arg;
        public final AnnotationMirror annotation;

        private AccessElements(@Nullable ExecutableElement read, @Nullable ExecutableElement write, @Nullable VariableElement arg, @Nullable VariableElement field, @Nullable AnnotationMirror annotation) {
            this.read = read;
            this.write = write;
            this.field = field;
            this.arg = arg;
            this.annotation = annotation;
        }

        public static AccessElements readWrite(ExecutableElement read, ExecutableElement write, @Nullable AnnotationMirror annotation) {
            return new AccessElements(read, write, null, null, annotation);
        }

        public static AccessElements field(VariableElement field, VariableElement arg, @Nullable AnnotationMirror annotation) {
            return new AccessElements(null, null, arg, field, annotation);
        }

        public static AccessElements readOnly(ExecutableElement read, VariableElement arg, @Nullable AnnotationMirror annotation) {
            return new AccessElements(read, null, arg, null, annotation);
        }

        public static AccessElements readOnly(VariableElement field, ExecutableElement write, @Nullable AnnotationMirror annotation) {
            return new AccessElements(null, write, null, field, annotation);
        }
    }

    private static enum PartKind {
        UNKNOWN,
        RAW_TYPE,
        TYPE_VARIABLE,
        OTHER;

    }

    public static class AnnotationMapping<T> {
        public final String name;
        public final T value;

        public AnnotationMapping(String name, @Nullable T value) {
            this.name = name;
            this.value = value;
        }
    }
}

