/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.stagemonitor.configuration.converter;

import co.elastic.apm.agent.shaded.stagemonitor.configuration.converter.AbstractValueConverter;

public class ClassInstanceValueConverter<T>
extends AbstractValueConverter<T> {
    private final Class<T> clazz;

    public static <T> ClassInstanceValueConverter<T> of(Class<T> clazz) {
        return new ClassInstanceValueConverter<T>(clazz);
    }

    private ClassInstanceValueConverter(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public T convert(String className) throws IllegalArgumentException {
        try {
            Class<?> aClass = Class.forName(className);
            if (this.clazz.isAssignableFrom(aClass)) {
                Class<?> tClazz = aClass;
                return (T)tClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            throw new IllegalArgumentException(aClass.getName() + " is not an instance of " + this.clazz.getName());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Did not find a public no arg constructor for " + className, e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String toString(T value) {
        return value.getClass().getName();
    }
}

