/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.stagemonitor.configuration.converter;

import co.elastic.apm.agent.shaded.stagemonitor.configuration.converter.AbstractCollectionValueConverter;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.converter.IntegerValueConverter;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.converter.StringValueConverter;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.converter.ValueConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListValueConverter<T>
extends AbstractCollectionValueConverter<List<T>, T> {
    public static final ListValueConverter<String> STRINGS_VALUE_CONVERTER = new ListValueConverter<String>(StringValueConverter.INSTANCE);
    public static final ListValueConverter<String> LOWER_STRINGS_VALUE_CONVERTER = new ListValueConverter<String>(StringValueConverter.LOWER_CASE);
    public static final ValueConverter<List<Integer>> INTEGERS = new ListValueConverter<Integer>(IntegerValueConverter.INSTANCE);

    public ListValueConverter(ValueConverter<T> valueConverter) {
        super(valueConverter);
    }

    @Override
    public List<T> convert(String s) {
        if (s != null && s.length() > 0) {
            ArrayList result = new ArrayList();
            for (String split : s.split(",")) {
                result.add(this.valueConverter.convert(split.trim()));
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }
}

