/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.weaklockfree;

import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;

public class DetachedThreadLocal<T>
implements Runnable {
    final WeakConcurrentMap<Thread, T> map;

    public DetachedThreadLocal(Cleaner cleaner) {
        switch (cleaner) {
            case THREAD: 
            case MANUAL: {
                this.map = new WeakConcurrentMap<Thread, T>(cleaner == Cleaner.THREAD){

                    @Override
                    protected T defaultValue(Thread key) {
                        return DetachedThreadLocal.this.initialValue(key);
                    }
                };
                break;
            }
            case INLINE: {
                this.map = new WeakConcurrentMap.WithInlinedExpunction<Thread, T>(){

                    @Override
                    protected T defaultValue(Thread key) {
                        return DetachedThreadLocal.this.initialValue(key);
                    }
                };
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public T get() {
        return this.map.get(Thread.currentThread());
    }

    public T getIfPresent() {
        return this.map.getIfPresent(Thread.currentThread());
    }

    public void set(T value) {
        this.map.put(Thread.currentThread(), value);
    }

    public void clear() {
        this.map.remove(Thread.currentThread());
    }

    public void clearAll() {
        this.map.clear();
    }

    public T pushTo(Thread thread) {
        T value = this.get();
        if (value != null) {
            this.map.put(thread, this.inheritValue(value));
        }
        return value;
    }

    public T fetchFrom(Thread thread) {
        T value = this.map.get(thread);
        if (value != null) {
            this.set(this.inheritValue(value));
        }
        return value;
    }

    public T get(Thread thread) {
        return this.map.get(thread);
    }

    public void define(Thread thread, T value) {
        this.map.put(thread, value);
    }

    protected T initialValue(Thread thread) {
        return null;
    }

    protected T inheritValue(T value) {
        return value;
    }

    public WeakConcurrentMap<Thread, T> getBackingMap() {
        return this.map;
    }

    @Override
    public void run() {
        this.map.run();
    }

    public static enum Cleaner {
        THREAD,
        INLINE,
        MANUAL;

    }
}

