/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.slf4j;

import co.elastic.apm.agent.cache.WeakKeySoftValueLoadingCache;
import co.elastic.apm.agent.impl.ActivationListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.logging.LoggingConfiguration;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.annotation.Nullable;

public class Slf4JMdcActivationListener
implements ActivationListener {
    private static final String ORG_SLF4J_MDC = "org." + "slf4j.MDC".toString();
    private static final String TRACE_ID = "trace.id";
    private static final String TRANSACTION_ID = "transaction.id";
    private static final Logger logger = LoggerFactory.getLogger(Slf4JMdcActivationListener.class);
    private static final MethodHandle NOOP = MethodHandles.constant(String.class, "ClassLoader cannot load slf4j API");
    private final WeakKeySoftValueLoadingCache<ClassLoader, MethodHandle> mdcPutMethodHandleCache = new WeakKeySoftValueLoadingCache<ClassLoader, MethodHandle>(new WeakKeySoftValueLoadingCache.ValueSupplier<ClassLoader, MethodHandle>(){

        @Override
        @Nullable
        public MethodHandle get(ClassLoader classLoader) {
            try {
                return MethodHandles.lookup().findStatic(classLoader.loadClass(ORG_SLF4J_MDC), "put", MethodType.methodType(Void.TYPE, String.class, String.class));
            }
            catch (Exception e) {
                logger.warn("Class loader " + classLoader + " cannot load slf4j API", e);
                return NOOP;
            }
        }
    });
    private final WeakKeySoftValueLoadingCache<ClassLoader, MethodHandle> mdcRemoveMethodHandleCache = new WeakKeySoftValueLoadingCache<ClassLoader, MethodHandle>(new WeakKeySoftValueLoadingCache.ValueSupplier<ClassLoader, MethodHandle>(){

        @Override
        @Nullable
        public MethodHandle get(ClassLoader classLoader) {
            try {
                return MethodHandles.lookup().findStatic(classLoader.loadClass(ORG_SLF4J_MDC), "remove", MethodType.methodType(Void.TYPE, String.class));
            }
            catch (Exception ignore) {
                return NOOP;
            }
        }
    });
    private final LoggingConfiguration config;
    private final ElasticApmTracer tracer;

    public Slf4JMdcActivationListener(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.config = tracer.getConfig(LoggingConfiguration.class);
    }

    @Override
    public void beforeActivate(TraceContextHolder<?> context) throws Throwable {
        MethodHandle put;
        if (this.config.isLogCorrelationEnabled() && (put = this.mdcPutMethodHandleCache.get(this.getApplicationClassLoader(context))) != null && put != NOOP) {
            TraceContext traceContext = context.getTraceContext();
            if (this.tracer.getActive() == null) {
                put.invokeExact(TRACE_ID, traceContext.getTraceId().toString());
                put.invokeExact(TRANSACTION_ID, traceContext.getTransactionId().toString());
            }
        }
    }

    @Override
    public void afterDeactivate(TraceContextHolder<?> deactivatedContext) throws Throwable {
        MethodHandle remove;
        if (this.config.isLogCorrelationEnabled() && (remove = this.mdcRemoveMethodHandleCache.get(this.getApplicationClassLoader(deactivatedContext))) != null && remove != NOOP && this.tracer.getActive() == null) {
            remove.invokeExact(TRACE_ID);
            remove.invokeExact(TRANSACTION_ID);
        }
    }

    private ClassLoader getApplicationClassLoader(TraceContextHolder<?> context) {
        ClassLoader applicationClassLoader = context.getTraceContext().getApplicationClassLoader();
        if (applicationClassLoader != null) {
            return applicationClassLoader;
        }
        return this.getFallbackClassLoader();
    }

    private ClassLoader getFallbackClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }
}

