/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.spring.webmvc;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.springframework.web.servlet.ModelAndView;

public class DispatcherServletRenderInstrumentation
extends ElasticApmInstrumentation {
    private static final String SPAN_TYPE = "template";
    private static final String SPAN_SUBTYPE = "dispatcher-servlet";
    private static final String SPAN_ACTION = "render";
    private static final String DISPATCHER_SERVLET_RENDER_METHOD = "DispatcherServlet#render";

    @Advice.OnMethodEnter(suppress=Throwable.class)
    private static void beforeExecute(@Advice.Argument(value=0) @Nullable ModelAndView modelAndView, @Advice.Local(value="span") Span span) {
        if (tracer == null || tracer.getActive() == null) {
            return;
        }
        TraceContextHolder<?> parent = tracer.getActive();
        span = (Span)parent.createSpan().withType(SPAN_TYPE).withSubtype(SPAN_SUBTYPE).withAction(SPAN_ACTION).withName(DISPATCHER_SERVLET_RENDER_METHOD);
        if (modelAndView != null && modelAndView.getViewName() != null) {
            ((Span)span.appendToName(" ")).appendToName(modelAndView.getViewName());
        }
        span.activate();
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    private static void afterExecute(@Advice.Local(value="span") @Nullable Span span, @Advice.Thrown @Nullable Throwable t) {
        if (span != null) {
            ((Span)((Span)span.captureException(t)).deactivate()).end();
        }
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.springframework.web.servlet.DispatcherServlet");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named(SPAN_ACTION).and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.springframework.web.servlet.ModelAndView"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.servlet.http.HttpServletRequest"))).and(ElementMatchers.takesArgument(2, ElementMatchers.named("javax.servlet.http.HttpServletResponse")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList(SPAN_SUBTYPE, SPAN_ACTION);
    }
}

