/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.web;

import co.elastic.apm.agent.util.PotentiallyMultiValuedMap;
import javax.annotation.Nullable;

public class ClientIpUtils {
    public static String getRealIp(PotentiallyMultiValuedMap headers, String remoteAddr) {
        String ip = headers.getFirst("X-Forwarded-For");
        if (ClientIpUtils.isEmpty(ip)) {
            ip = headers.getFirst("X-Real-IP");
        }
        if (ClientIpUtils.isEmpty(ip)) {
            ip = remoteAddr;
        }
        return ClientIpUtils.getFirstIp(ip);
    }

    private static boolean isEmpty(@Nullable String ip) {
        return ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip);
    }

    private static String getFirstIp(String ip) {
        int indexOfFirstComma = ip.indexOf(44);
        if (indexOfFirstComma != -1) {
            ip = ip.substring(0, indexOfFirstComma);
        }
        return ip;
    }
}

