/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._core.UpdateByQueryRethrottleResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class UpdateByQueryRethrottleRequest
extends RequestBase {
    private final String taskId;
    @Nullable
    private final Long requestsPerSecond;
    public static final Endpoint<UpdateByQueryRethrottleRequest, UpdateByQueryRethrottleResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<UpdateByQueryRethrottleRequest, UpdateByQueryRethrottleResponse>(request -> "POST", request -> {
        boolean _taskId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_update_by_query");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskId, buf);
            buf.append("/_rethrottle");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.requestsPerSecond != null) {
            params.put("requests_per_second", String.valueOf(request.requestsPerSecond));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, UpdateByQueryRethrottleResponse._DESERIALIZER);

    public UpdateByQueryRethrottleRequest(Builder builder) {
        this.taskId = Objects.requireNonNull(builder.taskId, "task_id");
        this.requestsPerSecond = builder.requestsPerSecond;
    }

    public UpdateByQueryRethrottleRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String taskId() {
        return this.taskId;
    }

    @Nullable
    public Long requestsPerSecond() {
        return this.requestsPerSecond;
    }

    public static class Builder
    implements ObjectBuilder<UpdateByQueryRethrottleRequest> {
        private String taskId;
        @Nullable
        private Long requestsPerSecond;

        public Builder taskId(String value) {
            this.taskId = value;
            return this;
        }

        public Builder requestsPerSecond(@Nullable Long value) {
            this.requestsPerSecond = value;
            return this;
        }

        @Override
        public UpdateByQueryRethrottleRequest build() {
            return new UpdateByQueryRethrottleRequest(this);
        }
    }
}

