/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.search;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FieldAndFormat
implements JsonpSerializable {
    private final String field;
    @Nullable
    private final String format;
    @Nullable
    private final Boolean includeUnmapped;
    public static final JsonpDeserializer<FieldAndFormat> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldAndFormat::setupFieldAndFormatDeserializer, Builder::build);

    public FieldAndFormat(Builder builder) {
        this.field = Objects.requireNonNull(builder.field, "field");
        this.format = builder.format;
        this.includeUnmapped = builder.includeUnmapped;
    }

    public FieldAndFormat(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public String format() {
        return this.format;
    }

    @Nullable
    public Boolean includeUnmapped() {
        return this.includeUnmapped;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.includeUnmapped != null) {
            generator.writeKey("include_unmapped");
            generator.write(this.includeUnmapped.booleanValue());
        }
    }

    protected static void setupFieldAndFormatDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format", new String[0]);
        op.add(Builder::includeUnmapped, JsonpDeserializer.booleanDeserializer(), "include_unmapped", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FieldAndFormat> {
        private String field;
        @Nullable
        private String format;
        @Nullable
        private Boolean includeUnmapped;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public Builder includeUnmapped(@Nullable Boolean value) {
            this.includeUnmapped = value;
            return this;
        }

        @Override
        public FieldAndFormat build() {
            return new FieldAndFormat(this);
        }
    }
}

