/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.search;

import co.elastic.clients.elasticsearch._core.search.SmoothingModelVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class LinearInterpolationSmoothingModel
implements SmoothingModelVariant,
JsonpSerializable {
    private final double bigramLambda;
    private final double trigramLambda;
    private final double unigramLambda;
    public static final JsonpDeserializer<LinearInterpolationSmoothingModel> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LinearInterpolationSmoothingModel::setupLinearInterpolationSmoothingModelDeserializer, Builder::build);

    public LinearInterpolationSmoothingModel(Builder builder) {
        this.bigramLambda = Objects.requireNonNull(builder.bigramLambda, "bigram_lambda");
        this.trigramLambda = Objects.requireNonNull(builder.trigramLambda, "trigram_lambda");
        this.unigramLambda = Objects.requireNonNull(builder.unigramLambda, "unigram_lambda");
    }

    public LinearInterpolationSmoothingModel(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "linear_interpolation";
    }

    public double bigramLambda() {
        return this.bigramLambda;
    }

    public double trigramLambda() {
        return this.trigramLambda;
    }

    public double unigramLambda() {
        return this.unigramLambda;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bigram_lambda");
        generator.write(this.bigramLambda);
        generator.writeKey("trigram_lambda");
        generator.write(this.trigramLambda);
        generator.writeKey("unigram_lambda");
        generator.write(this.unigramLambda);
    }

    protected static void setupLinearInterpolationSmoothingModelDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::bigramLambda, JsonpDeserializer.doubleDeserializer(), "bigram_lambda", new String[0]);
        op.add(Builder::trigramLambda, JsonpDeserializer.doubleDeserializer(), "trigram_lambda", new String[0]);
        op.add(Builder::unigramLambda, JsonpDeserializer.doubleDeserializer(), "unigram_lambda", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<LinearInterpolationSmoothingModel> {
        private Double bigramLambda;
        private Double trigramLambda;
        private Double unigramLambda;

        public Builder bigramLambda(double value) {
            this.bigramLambda = value;
            return this;
        }

        public Builder trigramLambda(double value) {
            this.trigramLambda = value;
            return this;
        }

        public Builder unigramLambda(double value) {
            this.unigramLambda = value;
            return this;
        }

        @Override
        public LinearInterpolationSmoothingModel build() {
            return new LinearInterpolationSmoothingModel(this);
        }
    }
}

