/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.search;

import co.elastic.clients.elasticsearch._core.search.RescoreQuery;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Rescore
implements JsonpSerializable {
    private final RescoreQuery query;
    @Nullable
    private final Integer windowSize;
    public static final JsonpDeserializer<Rescore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Rescore::setupRescoreDeserializer, Builder::build);

    public Rescore(Builder builder) {
        this.query = Objects.requireNonNull(builder.query, "query");
        this.windowSize = builder.windowSize;
    }

    public Rescore(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public RescoreQuery query() {
        return this.query;
    }

    @Nullable
    public Integer windowSize() {
        return this.windowSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        if (this.windowSize != null) {
            generator.writeKey("window_size");
            generator.write(this.windowSize.intValue());
        }
    }

    protected static void setupRescoreDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::query, RescoreQuery._DESERIALIZER, "query", new String[0]);
        op.add(Builder::windowSize, JsonpDeserializer.integerDeserializer(), "window_size", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Rescore> {
        private RescoreQuery query;
        @Nullable
        private Integer windowSize;

        public Builder query(RescoreQuery value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<RescoreQuery.Builder, ObjectBuilder<RescoreQuery>> fn) {
            return this.query(fn.apply(new RescoreQuery.Builder()).build());
        }

        public Builder windowSize(@Nullable Integer value) {
            this.windowSize = value;
            return this;
        }

        @Override
        public Rescore build() {
            return new Rescore(this);
        }
    }
}

