/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.search;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SuggestFuzziness
implements JsonpSerializable {
    private final String fuzziness;
    private final int minLength;
    private final int prefixLength;
    private final boolean transpositions;
    private final boolean unicodeAware;
    public static final JsonpDeserializer<SuggestFuzziness> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SuggestFuzziness::setupSuggestFuzzinessDeserializer, Builder::build);

    public SuggestFuzziness(Builder builder) {
        this.fuzziness = Objects.requireNonNull(builder.fuzziness, "fuzziness");
        this.minLength = Objects.requireNonNull(builder.minLength, "min_length");
        this.prefixLength = Objects.requireNonNull(builder.prefixLength, "prefix_length");
        this.transpositions = Objects.requireNonNull(builder.transpositions, "transpositions");
        this.unicodeAware = Objects.requireNonNull(builder.unicodeAware, "unicode_aware");
    }

    public SuggestFuzziness(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String fuzziness() {
        return this.fuzziness;
    }

    public int minLength() {
        return this.minLength;
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    public boolean transpositions() {
        return this.transpositions;
    }

    public boolean unicodeAware() {
        return this.unicodeAware;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("fuzziness");
        generator.write(this.fuzziness);
        generator.writeKey("min_length");
        generator.write(this.minLength);
        generator.writeKey("prefix_length");
        generator.write(this.prefixLength);
        generator.writeKey("transpositions");
        generator.write(this.transpositions);
        generator.writeKey("unicode_aware");
        generator.write(this.unicodeAware);
    }

    protected static void setupSuggestFuzzinessDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::fuzziness, JsonpDeserializer.stringDeserializer(), "fuzziness", new String[0]);
        op.add(Builder::minLength, JsonpDeserializer.integerDeserializer(), "min_length", new String[0]);
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length", new String[0]);
        op.add(Builder::transpositions, JsonpDeserializer.booleanDeserializer(), "transpositions", new String[0]);
        op.add(Builder::unicodeAware, JsonpDeserializer.booleanDeserializer(), "unicode_aware", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SuggestFuzziness> {
        private String fuzziness;
        private Integer minLength;
        private Integer prefixLength;
        private Boolean transpositions;
        private Boolean unicodeAware;

        public Builder fuzziness(String value) {
            this.fuzziness = value;
            return this;
        }

        public Builder minLength(int value) {
            this.minLength = value;
            return this;
        }

        public Builder prefixLength(int value) {
            this.prefixLength = value;
            return this;
        }

        public Builder transpositions(boolean value) {
            this.transpositions = value;
            return this;
        }

        public Builder unicodeAware(boolean value) {
            this.unicodeAware = value;
            return this;
        }

        @Override
        public SuggestFuzziness build() {
            return new SuggestFuzziness(this);
        }
    }
}

