/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.MetricAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CardinalityAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Integer precisionThreshold;
    @Nullable
    private final Boolean rehash;
    public static final JsonpDeserializer<CardinalityAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CardinalityAggregation::setupCardinalityAggregationDeserializer, Builder::build);

    public CardinalityAggregation(Builder builder) {
        super(builder);
        this.precisionThreshold = builder.precisionThreshold;
        this.rehash = builder.rehash;
    }

    public CardinalityAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "cardinality";
    }

    @Nullable
    public Integer precisionThreshold() {
        return this.precisionThreshold;
    }

    @Nullable
    public Boolean rehash() {
        return this.rehash;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.precisionThreshold != null) {
            generator.writeKey("precision_threshold");
            generator.write(this.precisionThreshold.intValue());
        }
        if (this.rehash != null) {
            generator.writeKey("rehash");
            generator.write(this.rehash.booleanValue());
        }
    }

    protected static void setupCardinalityAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        MetricAggregationBase.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::precisionThreshold, JsonpDeserializer.integerDeserializer(), "precision_threshold", new String[0]);
        op.add(Builder::rehash, JsonpDeserializer.booleanDeserializer(), "rehash", new String[0]);
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CardinalityAggregation> {
        @Nullable
        private Integer precisionThreshold;
        @Nullable
        private Boolean rehash;

        public Builder precisionThreshold(@Nullable Integer value) {
            this.precisionThreshold = value;
            return this;
        }

        public Builder rehash(@Nullable Boolean value) {
            this.rehash = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CardinalityAggregation build() {
            return new CardinalityAggregation(this);
        }
    }
}

