/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.PipelineAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PercentilesBucketAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    @Nullable
    private final List<Double> percents;
    public static final JsonpDeserializer<PercentilesBucketAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PercentilesBucketAggregation::setupPercentilesBucketAggregationDeserializer, Builder::build);

    public PercentilesBucketAggregation(Builder builder) {
        super(builder);
        this.percents = ModelTypeHelper.unmodifiable(builder.percents);
    }

    public PercentilesBucketAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "percentiles_bucket";
    }

    @Nullable
    public List<Double> percents() {
        return this.percents;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.percents != null) {
            generator.writeKey("percents");
            generator.writeStartArray();
            for (Double item0 : this.percents) {
                generator.write(item0.doubleValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupPercentilesBucketAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::percents, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "percents", new String[0]);
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PercentilesBucketAggregation> {
        @Nullable
        private List<Double> percents;

        public Builder percents(@Nullable List<Double> value) {
            this.percents = value;
            return this;
        }

        public Builder percents(Double ... value) {
            this.percents = Arrays.asList(value);
            return this;
        }

        public Builder addPercents(Double value) {
            if (this.percents == null) {
                this.percents = new ArrayList<Double>();
            }
            this.percents.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PercentilesBucketAggregation build() {
            return new PercentilesBucketAggregation(this);
        }
    }
}

