/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ScriptedHeuristic
implements JsonpSerializable {
    private final JsonValue script;
    public static final JsonpDeserializer<ScriptedHeuristic> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptedHeuristic::setupScriptedHeuristicDeserializer, Builder::build);

    public ScriptedHeuristic(Builder builder) {
        this.script = Objects.requireNonNull(builder.script, "script");
    }

    public ScriptedHeuristic(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public JsonValue script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("script");
        generator.write(this.script);
    }

    protected static void setupScriptedHeuristicDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ScriptedHeuristic> {
        private JsonValue script;

        public Builder script(JsonValue value) {
            this.script = value;
            return this;
        }

        @Override
        public ScriptedHeuristic build() {
            return new ScriptedHeuristic(this);
        }
    }
}

