/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationSourceVariant;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregationCollectMode;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregationExecutionHint;
import co.elastic.clients.elasticsearch.transform.PivotGroupByVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TermsAggregation
extends BucketAggregationBase
implements AggregationVariant,
PivotGroupByVariant,
CompositeAggregationSourceVariant {
    @Nullable
    private final TermsAggregationCollectMode collectMode;
    @Nullable
    private final List<String> exclude;
    @Nullable
    private final TermsAggregationExecutionHint executionHint;
    @Nullable
    private final String field;
    @Nullable
    private final JsonValue include;
    @Nullable
    private final Integer minDocCount;
    @Nullable
    private final String missing;
    @Nullable
    private final Boolean missingBucket;
    @Nullable
    private final String valueType;
    @Nullable
    private final JsonValue order;
    @Nullable
    private final JsonValue script;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final Boolean showTermDocCountError;
    @Nullable
    private final Integer size;
    public static final JsonpDeserializer<TermsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermsAggregation::setupTermsAggregationDeserializer, Builder::build);

    public TermsAggregation(Builder builder) {
        super(builder);
        this.collectMode = builder.collectMode;
        this.exclude = ModelTypeHelper.unmodifiable(builder.exclude);
        this.executionHint = builder.executionHint;
        this.field = builder.field;
        this.include = builder.include;
        this.minDocCount = builder.minDocCount;
        this.missing = builder.missing;
        this.missingBucket = builder.missingBucket;
        this.valueType = builder.valueType;
        this.order = builder.order;
        this.script = builder.script;
        this.shardSize = builder.shardSize;
        this.showTermDocCountError = builder.showTermDocCountError;
        this.size = builder.size;
    }

    public TermsAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "terms";
    }

    @Nullable
    public TermsAggregationCollectMode collectMode() {
        return this.collectMode;
    }

    @Nullable
    public List<String> exclude() {
        return this.exclude;
    }

    @Nullable
    public TermsAggregationExecutionHint executionHint() {
        return this.executionHint;
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Nullable
    public JsonValue include() {
        return this.include;
    }

    @Nullable
    public Integer minDocCount() {
        return this.minDocCount;
    }

    @Nullable
    public String missing() {
        return this.missing;
    }

    @Nullable
    public Boolean missingBucket() {
        return this.missingBucket;
    }

    @Nullable
    public String valueType() {
        return this.valueType;
    }

    @Nullable
    public JsonValue order() {
        return this.order;
    }

    @Nullable
    public JsonValue script() {
        return this.script;
    }

    @Nullable
    public Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public Boolean showTermDocCountError() {
        return this.showTermDocCountError;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.collectMode != null) {
            generator.writeKey("collect_mode");
            this.collectMode.serialize(generator, mapper);
        }
        if (this.exclude != null) {
            generator.writeKey("exclude");
            generator.writeStartArray();
            for (String item0 : this.exclude) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.executionHint != null) {
            generator.writeKey("execution_hint");
            this.executionHint.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.include != null) {
            generator.writeKey("include");
            generator.write(this.include);
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount.intValue());
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing);
        }
        if (this.missingBucket != null) {
            generator.writeKey("missing_bucket");
            generator.write(this.missingBucket.booleanValue());
        }
        if (this.valueType != null) {
            generator.writeKey("value_type");
            generator.write(this.valueType);
        }
        if (this.order != null) {
            generator.writeKey("order");
            generator.write(this.order);
        }
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.showTermDocCountError != null) {
            generator.writeKey("show_term_doc_count_error");
            generator.write(this.showTermDocCountError.booleanValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
    }

    protected static void setupTermsAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::collectMode, TermsAggregationCollectMode._DESERIALIZER, "collect_mode", new String[0]);
        op.add(Builder::exclude, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "exclude", new String[0]);
        op.add(Builder::executionHint, TermsAggregationExecutionHint._DESERIALIZER, "execution_hint", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::include, JsonpDeserializer.jsonValueDeserializer(), "include", new String[0]);
        op.add(Builder::minDocCount, JsonpDeserializer.integerDeserializer(), "min_doc_count", new String[0]);
        op.add(Builder::missing, JsonpDeserializer.stringDeserializer(), "missing", new String[0]);
        op.add(Builder::missingBucket, JsonpDeserializer.booleanDeserializer(), "missing_bucket", new String[0]);
        op.add(Builder::valueType, JsonpDeserializer.stringDeserializer(), "value_type", new String[0]);
        op.add(Builder::order, JsonpDeserializer.jsonValueDeserializer(), "order", new String[0]);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size", new String[0]);
        op.add(Builder::showTermDocCountError, JsonpDeserializer.booleanDeserializer(), "show_term_doc_count_error", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TermsAggregation> {
        @Nullable
        private TermsAggregationCollectMode collectMode;
        @Nullable
        private List<String> exclude;
        @Nullable
        private TermsAggregationExecutionHint executionHint;
        @Nullable
        private String field;
        @Nullable
        private JsonValue include;
        @Nullable
        private Integer minDocCount;
        @Nullable
        private String missing;
        @Nullable
        private Boolean missingBucket;
        @Nullable
        private String valueType;
        @Nullable
        private JsonValue order;
        @Nullable
        private JsonValue script;
        @Nullable
        private Integer shardSize;
        @Nullable
        private Boolean showTermDocCountError;
        @Nullable
        private Integer size;

        public Builder collectMode(@Nullable TermsAggregationCollectMode value) {
            this.collectMode = value;
            return this;
        }

        public Builder exclude(@Nullable List<String> value) {
            this.exclude = value;
            return this;
        }

        public Builder exclude(String ... value) {
            this.exclude = Arrays.asList(value);
            return this;
        }

        public Builder addExclude(String value) {
            if (this.exclude == null) {
                this.exclude = new ArrayList<String>();
            }
            this.exclude.add(value);
            return this;
        }

        public Builder executionHint(@Nullable TermsAggregationExecutionHint value) {
            this.executionHint = value;
            return this;
        }

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public Builder include(@Nullable JsonValue value) {
            this.include = value;
            return this;
        }

        public Builder minDocCount(@Nullable Integer value) {
            this.minDocCount = value;
            return this;
        }

        public Builder missing(@Nullable String value) {
            this.missing = value;
            return this;
        }

        public Builder missingBucket(@Nullable Boolean value) {
            this.missingBucket = value;
            return this;
        }

        public Builder valueType(@Nullable String value) {
            this.valueType = value;
            return this;
        }

        public Builder order(@Nullable JsonValue value) {
            this.order = value;
            return this;
        }

        public Builder script(@Nullable JsonValue value) {
            this.script = value;
            return this;
        }

        public Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public Builder showTermDocCountError(@Nullable Boolean value) {
            this.showTermDocCountError = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TermsAggregation build() {
            return new TermsAggregation(this);
        }
    }
}

