/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.AnalyzerVariant;
import co.elastic.clients.elasticsearch._types.analysis.CustomAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.FingerprintAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.IcuAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.KeywordAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.KuromojiAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.LanguageAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.NoriAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.PatternAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.SimpleAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.StandardAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.StopAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.WhitespaceAnalyzer;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Analyzer
implements TaggedUnion<JsonpSerializable>,
JsonpSerializable {
    public static final String CUSTOM = "custom";
    public static final String FINGERPRINT = "fingerprint";
    public static final String KEYWORD = "keyword";
    public static final String LANGUAGE = "language";
    public static final String NORI = "nori";
    public static final String PATTERN = "pattern";
    public static final String SIMPLE = "simple";
    public static final String STANDARD = "standard";
    public static final String STOP = "stop";
    public static final String WHITESPACE = "whitespace";
    public static final String ICU_ANALYZER = "icu_analyzer";
    public static final String KUROMOJI = "kuromoji";
    private final String _type;
    private final JsonpSerializable _value;
    public static final JsonpDeserializer<Analyzer> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Analyzer::setupAnalyzerDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public JsonpSerializable _get() {
        return this._value;
    }

    public Analyzer(AnalyzerVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private Analyzer(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Analyzer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public CustomAnalyzer custom() {
        return (CustomAnalyzer)TaggedUnionUtils.get(this, CUSTOM);
    }

    public FingerprintAnalyzer fingerprint() {
        return (FingerprintAnalyzer)TaggedUnionUtils.get(this, FINGERPRINT);
    }

    public KeywordAnalyzer keyword() {
        return (KeywordAnalyzer)TaggedUnionUtils.get(this, KEYWORD);
    }

    public LanguageAnalyzer language() {
        return (LanguageAnalyzer)TaggedUnionUtils.get(this, LANGUAGE);
    }

    public NoriAnalyzer nori() {
        return (NoriAnalyzer)TaggedUnionUtils.get(this, NORI);
    }

    public PatternAnalyzer pattern() {
        return (PatternAnalyzer)TaggedUnionUtils.get(this, PATTERN);
    }

    public SimpleAnalyzer simple() {
        return (SimpleAnalyzer)TaggedUnionUtils.get(this, SIMPLE);
    }

    public StandardAnalyzer standard() {
        return (StandardAnalyzer)TaggedUnionUtils.get(this, STANDARD);
    }

    public StopAnalyzer stop() {
        return (StopAnalyzer)TaggedUnionUtils.get(this, STOP);
    }

    public WhitespaceAnalyzer whitespace() {
        return (WhitespaceAnalyzer)TaggedUnionUtils.get(this, WHITESPACE);
    }

    public IcuAnalyzer icuAnalyzer() {
        return (IcuAnalyzer)TaggedUnionUtils.get(this, ICU_ANALYZER);
    }

    public KuromojiAnalyzer kuromoji() {
        return (KuromojiAnalyzer)TaggedUnionUtils.get(this, KUROMOJI);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this._value.serialize(generator, mapper);
    }

    protected static void setupAnalyzerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::custom, CustomAnalyzer._DESERIALIZER, CUSTOM, new String[0]);
        op.add(Builder::fingerprint, FingerprintAnalyzer._DESERIALIZER, FINGERPRINT, new String[0]);
        op.add(Builder::keyword, KeywordAnalyzer._DESERIALIZER, KEYWORD, new String[0]);
        op.add(Builder::language, LanguageAnalyzer._DESERIALIZER, LANGUAGE, new String[0]);
        op.add(Builder::nori, NoriAnalyzer._DESERIALIZER, NORI, new String[0]);
        op.add(Builder::pattern, PatternAnalyzer._DESERIALIZER, PATTERN, new String[0]);
        op.add(Builder::simple, SimpleAnalyzer._DESERIALIZER, SIMPLE, new String[0]);
        op.add(Builder::standard, StandardAnalyzer._DESERIALIZER, STANDARD, new String[0]);
        op.add(Builder::stop, StopAnalyzer._DESERIALIZER, STOP, new String[0]);
        op.add(Builder::whitespace, WhitespaceAnalyzer._DESERIALIZER, WHITESPACE, new String[0]);
        op.add(Builder::icuAnalyzer, IcuAnalyzer._DESERIALIZER, ICU_ANALYZER, new String[0]);
        op.add(Builder::kuromoji, KuromojiAnalyzer._DESERIALIZER, KUROMOJI, new String[0]);
        op.setTypeProperty("type");
    }

    public static class Builder
    implements ObjectBuilder<Analyzer> {
        private String _type;
        private JsonpSerializable _value;

        public Builder custom(CustomAnalyzer v) {
            this._type = Analyzer.CUSTOM;
            this._value = v;
            return this;
        }

        public Builder custom(Function<CustomAnalyzer.Builder, ObjectBuilder<CustomAnalyzer>> f) {
            return this.custom(f.apply(new CustomAnalyzer.Builder()).build());
        }

        public Builder fingerprint(FingerprintAnalyzer v) {
            this._type = Analyzer.FINGERPRINT;
            this._value = v;
            return this;
        }

        public Builder fingerprint(Function<FingerprintAnalyzer.Builder, ObjectBuilder<FingerprintAnalyzer>> f) {
            return this.fingerprint(f.apply(new FingerprintAnalyzer.Builder()).build());
        }

        public Builder keyword(KeywordAnalyzer v) {
            this._type = Analyzer.KEYWORD;
            this._value = v;
            return this;
        }

        public Builder keyword(Function<KeywordAnalyzer.Builder, ObjectBuilder<KeywordAnalyzer>> f) {
            return this.keyword(f.apply(new KeywordAnalyzer.Builder()).build());
        }

        public Builder language(LanguageAnalyzer v) {
            this._type = Analyzer.LANGUAGE;
            this._value = v;
            return this;
        }

        public Builder language(Function<LanguageAnalyzer.Builder, ObjectBuilder<LanguageAnalyzer>> f) {
            return this.language(f.apply(new LanguageAnalyzer.Builder()).build());
        }

        public Builder nori(NoriAnalyzer v) {
            this._type = Analyzer.NORI;
            this._value = v;
            return this;
        }

        public Builder nori(Function<NoriAnalyzer.Builder, ObjectBuilder<NoriAnalyzer>> f) {
            return this.nori(f.apply(new NoriAnalyzer.Builder()).build());
        }

        public Builder pattern(PatternAnalyzer v) {
            this._type = Analyzer.PATTERN;
            this._value = v;
            return this;
        }

        public Builder pattern(Function<PatternAnalyzer.Builder, ObjectBuilder<PatternAnalyzer>> f) {
            return this.pattern(f.apply(new PatternAnalyzer.Builder()).build());
        }

        public Builder simple(SimpleAnalyzer v) {
            this._type = Analyzer.SIMPLE;
            this._value = v;
            return this;
        }

        public Builder simple(Function<SimpleAnalyzer.Builder, ObjectBuilder<SimpleAnalyzer>> f) {
            return this.simple(f.apply(new SimpleAnalyzer.Builder()).build());
        }

        public Builder standard(StandardAnalyzer v) {
            this._type = Analyzer.STANDARD;
            this._value = v;
            return this;
        }

        public Builder standard(Function<StandardAnalyzer.Builder, ObjectBuilder<StandardAnalyzer>> f) {
            return this.standard(f.apply(new StandardAnalyzer.Builder()).build());
        }

        public Builder stop(StopAnalyzer v) {
            this._type = Analyzer.STOP;
            this._value = v;
            return this;
        }

        public Builder stop(Function<StopAnalyzer.Builder, ObjectBuilder<StopAnalyzer>> f) {
            return this.stop(f.apply(new StopAnalyzer.Builder()).build());
        }

        public Builder whitespace(WhitespaceAnalyzer v) {
            this._type = Analyzer.WHITESPACE;
            this._value = v;
            return this;
        }

        public Builder whitespace(Function<WhitespaceAnalyzer.Builder, ObjectBuilder<WhitespaceAnalyzer>> f) {
            return this.whitespace(f.apply(new WhitespaceAnalyzer.Builder()).build());
        }

        public Builder icuAnalyzer(IcuAnalyzer v) {
            this._type = Analyzer.ICU_ANALYZER;
            this._value = v;
            return this;
        }

        public Builder icuAnalyzer(Function<IcuAnalyzer.Builder, ObjectBuilder<IcuAnalyzer>> f) {
            return this.icuAnalyzer(f.apply(new IcuAnalyzer.Builder()).build());
        }

        public Builder kuromoji(KuromojiAnalyzer v) {
            this._type = Analyzer.KUROMOJI;
            this._value = v;
            return this;
        }

        public Builder kuromoji(Function<KuromojiAnalyzer.Builder, ObjectBuilder<KuromojiAnalyzer>> f) {
            return this.kuromoji(f.apply(new KuromojiAnalyzer.Builder()).build());
        }

        @Override
        public Analyzer build() {
            return new Analyzer(this);
        }
    }
}

