/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.util.ModelTypeHelper;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class CompoundWordTokenFilterBase
extends TokenFilterBase {
    private final String hyphenationPatternsPath;
    private final int maxSubwordSize;
    private final int minSubwordSize;
    private final int minWordSize;
    private final boolean onlyLongestMatch;
    private final List<String> wordList;
    private final String wordListPath;

    public CompoundWordTokenFilterBase(AbstractBuilder<?> builder) {
        super(builder);
        this.hyphenationPatternsPath = Objects.requireNonNull(((AbstractBuilder)builder).hyphenationPatternsPath, "hyphenation_patterns_path");
        this.maxSubwordSize = Objects.requireNonNull(((AbstractBuilder)builder).maxSubwordSize, "max_subword_size");
        this.minSubwordSize = Objects.requireNonNull(((AbstractBuilder)builder).minSubwordSize, "min_subword_size");
        this.minWordSize = Objects.requireNonNull(((AbstractBuilder)builder).minWordSize, "min_word_size");
        this.onlyLongestMatch = Objects.requireNonNull(((AbstractBuilder)builder).onlyLongestMatch, "only_longest_match");
        this.wordList = ModelTypeHelper.unmodifiableNonNull(((AbstractBuilder)builder).wordList, "word_list");
        this.wordListPath = Objects.requireNonNull(((AbstractBuilder)builder).wordListPath, "word_list_path");
    }

    public String hyphenationPatternsPath() {
        return this.hyphenationPatternsPath;
    }

    public int maxSubwordSize() {
        return this.maxSubwordSize;
    }

    public int minSubwordSize() {
        return this.minSubwordSize;
    }

    public int minWordSize() {
        return this.minWordSize;
    }

    public boolean onlyLongestMatch() {
        return this.onlyLongestMatch;
    }

    public List<String> wordList() {
        return this.wordList;
    }

    public String wordListPath() {
        return this.wordListPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("hyphenation_patterns_path");
        generator.write(this.hyphenationPatternsPath);
        generator.writeKey("max_subword_size");
        generator.write(this.maxSubwordSize);
        generator.writeKey("min_subword_size");
        generator.write(this.minSubwordSize);
        generator.writeKey("min_word_size");
        generator.write(this.minWordSize);
        generator.writeKey("only_longest_match");
        generator.write(this.onlyLongestMatch);
        generator.writeKey("word_list");
        generator.writeStartArray();
        for (String item0 : this.wordList) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("word_list_path");
        generator.write(this.wordListPath);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupCompoundWordTokenFilterBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(AbstractBuilder::hyphenationPatternsPath, JsonpDeserializer.stringDeserializer(), "hyphenation_patterns_path", new String[0]);
        op.add(AbstractBuilder::maxSubwordSize, JsonpDeserializer.integerDeserializer(), "max_subword_size", new String[0]);
        op.add(AbstractBuilder::minSubwordSize, JsonpDeserializer.integerDeserializer(), "min_subword_size", new String[0]);
        op.add(AbstractBuilder::minWordSize, JsonpDeserializer.integerDeserializer(), "min_word_size", new String[0]);
        op.add(AbstractBuilder::onlyLongestMatch, JsonpDeserializer.booleanDeserializer(), "only_longest_match", new String[0]);
        op.add(AbstractBuilder::wordList, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "word_list", new String[0]);
        op.add(AbstractBuilder::wordListPath, JsonpDeserializer.stringDeserializer(), "word_list_path", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends TokenFilterBase.AbstractBuilder<BuilderT> {
        private String hyphenationPatternsPath;
        private Integer maxSubwordSize;
        private Integer minSubwordSize;
        private Integer minWordSize;
        private Boolean onlyLongestMatch;
        private List<String> wordList;
        private String wordListPath;

        protected AbstractBuilder() {
        }

        public BuilderT hyphenationPatternsPath(String value) {
            this.hyphenationPatternsPath = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT maxSubwordSize(int value) {
            this.maxSubwordSize = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT minSubwordSize(int value) {
            this.minSubwordSize = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT minWordSize(int value) {
            this.minWordSize = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT onlyLongestMatch(boolean value) {
            this.onlyLongestMatch = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT wordList(List<String> value) {
            this.wordList = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT wordList(String ... value) {
            this.wordList = Arrays.asList(value);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT addWordList(String value) {
            if (this.wordList == null) {
                this.wordList = new ArrayList<String>();
            }
            this.wordList.add(value);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT wordListPath(String value) {
            this.wordListPath = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

