/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.AnalyzerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CustomAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    @Nullable
    private final List<String> charFilter;
    @Nullable
    private final List<String> filter;
    @Nullable
    private final Integer positionIncrementGap;
    @Nullable
    private final Integer positionOffsetGap;
    private final String tokenizer;
    public static final JsonpDeserializer<CustomAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CustomAnalyzer::setupCustomAnalyzerDeserializer, Builder::build);

    public CustomAnalyzer(Builder builder) {
        this.charFilter = ModelTypeHelper.unmodifiable(builder.charFilter);
        this.filter = ModelTypeHelper.unmodifiable(builder.filter);
        this.positionIncrementGap = builder.positionIncrementGap;
        this.positionOffsetGap = builder.positionOffsetGap;
        this.tokenizer = Objects.requireNonNull(builder.tokenizer, "tokenizer");
    }

    public CustomAnalyzer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "custom";
    }

    @Nullable
    public List<String> charFilter() {
        return this.charFilter;
    }

    @Nullable
    public List<String> filter() {
        return this.filter;
    }

    @Nullable
    public Integer positionIncrementGap() {
        return this.positionIncrementGap;
    }

    @Nullable
    public Integer positionOffsetGap() {
        return this.positionOffsetGap;
    }

    public String tokenizer() {
        return this.tokenizer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "custom");
        if (this.charFilter != null) {
            generator.writeKey("char_filter");
            generator.writeStartArray();
            for (String item0 : this.charFilter) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (String item0 : this.filter) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.positionIncrementGap != null) {
            generator.writeKey("position_increment_gap");
            generator.write(this.positionIncrementGap.intValue());
        }
        if (this.positionOffsetGap != null) {
            generator.writeKey("position_offset_gap");
            generator.write(this.positionOffsetGap.intValue());
        }
        generator.writeKey("tokenizer");
        generator.write(this.tokenizer);
    }

    protected static void setupCustomAnalyzerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::charFilter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "char_filter", new String[0]);
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "filter", new String[0]);
        op.add(Builder::positionIncrementGap, JsonpDeserializer.integerDeserializer(), "position_increment_gap", new String[0]);
        op.add(Builder::positionOffsetGap, JsonpDeserializer.integerDeserializer(), "position_offset_gap", new String[0]);
        op.add(Builder::tokenizer, JsonpDeserializer.stringDeserializer(), "tokenizer", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    implements ObjectBuilder<CustomAnalyzer> {
        @Nullable
        private List<String> charFilter;
        @Nullable
        private List<String> filter;
        @Nullable
        private Integer positionIncrementGap;
        @Nullable
        private Integer positionOffsetGap;
        private String tokenizer;

        public Builder charFilter(@Nullable List<String> value) {
            this.charFilter = value;
            return this;
        }

        public Builder charFilter(String ... value) {
            this.charFilter = Arrays.asList(value);
            return this;
        }

        public Builder addCharFilter(String value) {
            if (this.charFilter == null) {
                this.charFilter = new ArrayList<String>();
            }
            this.charFilter.add(value);
            return this;
        }

        public Builder filter(@Nullable List<String> value) {
            this.filter = value;
            return this;
        }

        public Builder filter(String ... value) {
            this.filter = Arrays.asList(value);
            return this;
        }

        public Builder addFilter(String value) {
            if (this.filter == null) {
                this.filter = new ArrayList<String>();
            }
            this.filter.add(value);
            return this;
        }

        public Builder positionIncrementGap(@Nullable Integer value) {
            this.positionIncrementGap = value;
            return this;
        }

        public Builder positionOffsetGap(@Nullable Integer value) {
            this.positionOffsetGap = value;
            return this;
        }

        public Builder tokenizer(String value) {
            this.tokenizer = value;
            return this;
        }

        @Override
        public CustomAnalyzer build() {
            return new CustomAnalyzer(this);
        }
    }
}

