/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.NormalizerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CustomNormalizer
implements NormalizerVariant,
JsonpSerializable {
    @Nullable
    private final List<String> charFilter;
    @Nullable
    private final List<String> filter;
    public static final JsonpDeserializer<CustomNormalizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CustomNormalizer::setupCustomNormalizerDeserializer, Builder::build);

    public CustomNormalizer(Builder builder) {
        this.charFilter = ModelTypeHelper.unmodifiable(builder.charFilter);
        this.filter = ModelTypeHelper.unmodifiable(builder.filter);
    }

    public CustomNormalizer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "custom";
    }

    @Nullable
    public List<String> charFilter() {
        return this.charFilter;
    }

    @Nullable
    public List<String> filter() {
        return this.filter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "custom");
        if (this.charFilter != null) {
            generator.writeKey("char_filter");
            generator.writeStartArray();
            for (String item0 : this.charFilter) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (String item0 : this.filter) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupCustomNormalizerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::charFilter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "char_filter", new String[0]);
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "filter", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    implements ObjectBuilder<CustomNormalizer> {
        @Nullable
        private List<String> charFilter;
        @Nullable
        private List<String> filter;

        public Builder charFilter(@Nullable List<String> value) {
            this.charFilter = value;
            return this;
        }

        public Builder charFilter(String ... value) {
            this.charFilter = Arrays.asList(value);
            return this;
        }

        public Builder addCharFilter(String value) {
            if (this.charFilter == null) {
                this.charFilter = new ArrayList<String>();
            }
            this.charFilter.add(value);
            return this;
        }

        public Builder filter(@Nullable List<String> value) {
            this.filter = value;
            return this;
        }

        public Builder filter(String ... value) {
            this.filter = Arrays.asList(value);
            return this;
        }

        public Builder addFilter(String value) {
            if (this.filter == null) {
                this.filter = new ArrayList<String>();
            }
            this.filter.add(value);
            return this;
        }

        @Override
        public CustomNormalizer build() {
            return new CustomNormalizer(this);
        }
    }
}

