/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class KuromojiPartOfSpeechTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final List<String> stoptags;
    public static final JsonpDeserializer<KuromojiPartOfSpeechTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KuromojiPartOfSpeechTokenFilter::setupKuromojiPartOfSpeechTokenFilterDeserializer, Builder::build);

    public KuromojiPartOfSpeechTokenFilter(Builder builder) {
        super(builder);
        this.stoptags = ModelTypeHelper.unmodifiableNonNull(builder.stoptags, "stoptags");
    }

    public KuromojiPartOfSpeechTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "kuromoji_part_of_speech";
    }

    public List<String> stoptags() {
        return this.stoptags;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "kuromoji_part_of_speech");
        super.serializeInternal(generator, mapper);
        generator.writeKey("stoptags");
        generator.writeStartArray();
        for (String item0 : this.stoptags) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupKuromojiPartOfSpeechTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::stoptags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stoptags", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KuromojiPartOfSpeechTokenFilter> {
        private List<String> stoptags;

        public Builder stoptags(List<String> value) {
            this.stoptags = value;
            return this;
        }

        public Builder stoptags(String ... value) {
            this.stoptags = Arrays.asList(value);
            return this;
        }

        public Builder addStoptags(String value) {
            if (this.stoptags == null) {
                this.stoptags = new ArrayList<String>();
            }
            this.stoptags.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KuromojiPartOfSpeechTokenFilter build() {
            return new KuromojiPartOfSpeechTokenFilter(this);
        }
    }
}

