/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch.indices.NumericFielddata;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class BooleanProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Double boost;
    @Nullable
    private final NumericFielddata fielddata;
    @Nullable
    private final Boolean index;
    @Nullable
    private final Boolean nullValue;
    public static final JsonpDeserializer<BooleanProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BooleanProperty::setupBooleanPropertyDeserializer, Builder::build);

    public BooleanProperty(Builder builder) {
        super(builder);
        this.boost = builder.boost;
        this.fielddata = builder.fielddata;
        this.index = builder.index;
        this.nullValue = builder.nullValue;
    }

    public BooleanProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "boolean";
    }

    @Nullable
    public Double boost() {
        return this.boost;
    }

    @Nullable
    public NumericFielddata fielddata() {
        return this.fielddata;
    }

    @Nullable
    public Boolean index() {
        return this.index;
    }

    @Nullable
    public Boolean nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "boolean");
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.fielddata != null) {
            generator.writeKey("fielddata");
            this.fielddata.serialize(generator, mapper);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue.booleanValue());
        }
    }

    protected static void setupBooleanPropertyDeserializer(DelegatingDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost", new String[0]);
        op.add(Builder::fielddata, NumericFielddata._DESERIALIZER, "fielddata", new String[0]);
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index", new String[0]);
        op.add(Builder::nullValue, JsonpDeserializer.booleanDeserializer(), "null_value", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BooleanProperty> {
        @Nullable
        private Double boost;
        @Nullable
        private NumericFielddata fielddata;
        @Nullable
        private Boolean index;
        @Nullable
        private Boolean nullValue;

        public Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public Builder fielddata(@Nullable NumericFielddata value) {
            this.fielddata = value;
            return this;
        }

        public Builder fielddata(Function<NumericFielddata.Builder, ObjectBuilder<NumericFielddata>> fn) {
            return this.fielddata(fn.apply(new NumericFielddata.Builder()).build());
        }

        public Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public Builder nullValue(@Nullable Boolean value) {
            this.nullValue = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BooleanProperty build() {
            return new BooleanProperty(this);
        }
    }
}

