/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch._types.mapping.SuggestContext;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CompletionProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final String analyzer;
    @Nullable
    private final List<SuggestContext> contexts;
    @Nullable
    private final Integer maxInputLength;
    @Nullable
    private final Boolean preservePositionIncrements;
    @Nullable
    private final Boolean preserveSeparators;
    @Nullable
    private final String searchAnalyzer;
    public static final JsonpDeserializer<CompletionProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompletionProperty::setupCompletionPropertyDeserializer, Builder::build);

    public CompletionProperty(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.contexts = ModelTypeHelper.unmodifiable(builder.contexts);
        this.maxInputLength = builder.maxInputLength;
        this.preservePositionIncrements = builder.preservePositionIncrements;
        this.preserveSeparators = builder.preserveSeparators;
        this.searchAnalyzer = builder.searchAnalyzer;
    }

    public CompletionProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "completion";
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public List<SuggestContext> contexts() {
        return this.contexts;
    }

    @Nullable
    public Integer maxInputLength() {
        return this.maxInputLength;
    }

    @Nullable
    public Boolean preservePositionIncrements() {
        return this.preservePositionIncrements;
    }

    @Nullable
    public Boolean preserveSeparators() {
        return this.preserveSeparators;
    }

    @Nullable
    public String searchAnalyzer() {
        return this.searchAnalyzer;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "completion");
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.contexts != null) {
            generator.writeKey("contexts");
            generator.writeStartArray();
            for (SuggestContext item0 : this.contexts) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxInputLength != null) {
            generator.writeKey("max_input_length");
            generator.write(this.maxInputLength.intValue());
        }
        if (this.preservePositionIncrements != null) {
            generator.writeKey("preserve_position_increments");
            generator.write(this.preservePositionIncrements.booleanValue());
        }
        if (this.preserveSeparators != null) {
            generator.writeKey("preserve_separators");
            generator.write(this.preserveSeparators.booleanValue());
        }
        if (this.searchAnalyzer != null) {
            generator.writeKey("search_analyzer");
            generator.write(this.searchAnalyzer);
        }
    }

    protected static void setupCompletionPropertyDeserializer(DelegatingDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer", new String[0]);
        op.add(Builder::contexts, JsonpDeserializer.arrayDeserializer(SuggestContext._DESERIALIZER), "contexts", new String[0]);
        op.add(Builder::maxInputLength, JsonpDeserializer.integerDeserializer(), "max_input_length", new String[0]);
        op.add(Builder::preservePositionIncrements, JsonpDeserializer.booleanDeserializer(), "preserve_position_increments", new String[0]);
        op.add(Builder::preserveSeparators, JsonpDeserializer.booleanDeserializer(), "preserve_separators", new String[0]);
        op.add(Builder::searchAnalyzer, JsonpDeserializer.stringDeserializer(), "search_analyzer", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CompletionProperty> {
        @Nullable
        private String analyzer;
        @Nullable
        private List<SuggestContext> contexts;
        @Nullable
        private Integer maxInputLength;
        @Nullable
        private Boolean preservePositionIncrements;
        @Nullable
        private Boolean preserveSeparators;
        @Nullable
        private String searchAnalyzer;

        public Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public Builder contexts(@Nullable List<SuggestContext> value) {
            this.contexts = value;
            return this;
        }

        public Builder contexts(SuggestContext ... value) {
            this.contexts = Arrays.asList(value);
            return this;
        }

        public Builder addContexts(SuggestContext value) {
            if (this.contexts == null) {
                this.contexts = new ArrayList<SuggestContext>();
            }
            this.contexts.add(value);
            return this;
        }

        public Builder contexts(Function<SuggestContext.Builder, ObjectBuilder<SuggestContext>> fn) {
            return this.contexts(fn.apply(new SuggestContext.Builder()).build());
        }

        public Builder addContexts(Function<SuggestContext.Builder, ObjectBuilder<SuggestContext>> fn) {
            return this.addContexts(fn.apply(new SuggestContext.Builder()).build());
        }

        public Builder maxInputLength(@Nullable Integer value) {
            this.maxInputLength = value;
            return this;
        }

        public Builder preservePositionIncrements(@Nullable Boolean value) {
            this.preservePositionIncrements = value;
            return this;
        }

        public Builder preserveSeparators(@Nullable Boolean value) {
            this.preserveSeparators = value;
            return this;
        }

        public Builder searchAnalyzer(@Nullable String value) {
            this.searchAnalyzer = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompletionProperty build() {
            return new CompletionProperty(this);
        }
    }
}

