/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class HistogramProperty
extends PropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean ignoreMalformed;
    public static final JsonpDeserializer<HistogramProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HistogramProperty::setupHistogramPropertyDeserializer, Builder::build);

    public HistogramProperty(Builder builder) {
        super(builder);
        this.ignoreMalformed = builder.ignoreMalformed;
    }

    public HistogramProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "histogram";
    }

    @Nullable
    public Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "histogram");
        super.serializeInternal(generator, mapper);
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
    }

    protected static void setupHistogramPropertyDeserializer(DelegatingDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HistogramProperty> {
        @Nullable
        private Boolean ignoreMalformed;

        public Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HistogramProperty build() {
            return new HistogramProperty(this);
        }
    }
}

