/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsAllOf;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsAnyOf;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsFuzzy;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsMatch;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsPrefix;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsWildcard;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Intervals
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String ALL_OF = "all_of";
    public static final String ANY_OF = "any_of";
    public static final String FUZZY = "fuzzy";
    public static final String MATCH = "match";
    public static final String PREFIX = "prefix";
    public static final String WILDCARD = "wildcard";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<Intervals> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Intervals::setupIntervalsDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public Intervals(IntervalsVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private Intervals(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Intervals(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public IntervalsAllOf allOf() {
        return (IntervalsAllOf)TaggedUnionUtils.get(this, ALL_OF);
    }

    public IntervalsAnyOf anyOf() {
        return (IntervalsAnyOf)TaggedUnionUtils.get(this, ANY_OF);
    }

    public IntervalsFuzzy fuzzy() {
        return (IntervalsFuzzy)TaggedUnionUtils.get(this, FUZZY);
    }

    public IntervalsMatch match() {
        return (IntervalsMatch)TaggedUnionUtils.get(this, MATCH);
    }

    public IntervalsPrefix prefix() {
        return (IntervalsPrefix)TaggedUnionUtils.get(this, PREFIX);
    }

    public IntervalsWildcard wildcard() {
        return (IntervalsWildcard)TaggedUnionUtils.get(this, WILDCARD);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupIntervalsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::allOf, IntervalsAllOf._DESERIALIZER, ALL_OF, new String[0]);
        op.add(Builder::anyOf, IntervalsAnyOf._DESERIALIZER, ANY_OF, new String[0]);
        op.add(Builder::fuzzy, IntervalsFuzzy._DESERIALIZER, FUZZY, new String[0]);
        op.add(Builder::match, IntervalsMatch._DESERIALIZER, MATCH, new String[0]);
        op.add(Builder::prefix, IntervalsPrefix._DESERIALIZER, PREFIX, new String[0]);
        op.add(Builder::wildcard, IntervalsWildcard._DESERIALIZER, WILDCARD, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Intervals> {
        private String _type;
        private Object _value;

        public Builder allOf(IntervalsAllOf v) {
            this._type = Intervals.ALL_OF;
            this._value = v;
            return this;
        }

        public Builder allOf(Function<IntervalsAllOf.Builder, ObjectBuilder<IntervalsAllOf>> f) {
            return this.allOf(f.apply(new IntervalsAllOf.Builder()).build());
        }

        public Builder anyOf(IntervalsAnyOf v) {
            this._type = Intervals.ANY_OF;
            this._value = v;
            return this;
        }

        public Builder anyOf(Function<IntervalsAnyOf.Builder, ObjectBuilder<IntervalsAnyOf>> f) {
            return this.anyOf(f.apply(new IntervalsAnyOf.Builder()).build());
        }

        public Builder fuzzy(IntervalsFuzzy v) {
            this._type = Intervals.FUZZY;
            this._value = v;
            return this;
        }

        public Builder fuzzy(Function<IntervalsFuzzy.Builder, ObjectBuilder<IntervalsFuzzy>> f) {
            return this.fuzzy(f.apply(new IntervalsFuzzy.Builder()).build());
        }

        public Builder match(IntervalsMatch v) {
            this._type = Intervals.MATCH;
            this._value = v;
            return this;
        }

        public Builder match(Function<IntervalsMatch.Builder, ObjectBuilder<IntervalsMatch>> f) {
            return this.match(f.apply(new IntervalsMatch.Builder()).build());
        }

        public Builder prefix(IntervalsPrefix v) {
            this._type = Intervals.PREFIX;
            this._value = v;
            return this;
        }

        public Builder prefix(Function<IntervalsPrefix.Builder, ObjectBuilder<IntervalsPrefix>> f) {
            return this.prefix(f.apply(new IntervalsPrefix.Builder()).build());
        }

        public Builder wildcard(IntervalsWildcard v) {
            this._type = Intervals.WILDCARD;
            this._value = v;
            return this;
        }

        public Builder wildcard(Function<IntervalsWildcard.Builder, ObjectBuilder<IntervalsWildcard>> f) {
            return this.wildcard(f.apply(new IntervalsWildcard.Builder()).build());
        }

        @Override
        public Intervals build() {
            return new Intervals(this);
        }
    }
}

