/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.FielddataResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class FielddataRequest
extends CatRequestBase {
    @Nullable
    private final List<String> fields;
    @Nullable
    private final Bytes bytes;
    public static final Endpoint<FielddataRequest, FielddataResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<FielddataRequest, FielddataResponse>(request -> "GET", request -> {
        boolean _fields = true;
        boolean propsSet = false;
        if (request.fields() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/fielddata");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/fielddata");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.fields.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.bytes != null) {
            params.put("bytes", request.bytes.toString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, FielddataResponse._DESERIALIZER);

    public FielddataRequest(Builder builder) {
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.bytes = builder.bytes;
    }

    public FielddataRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> fields() {
        return this.fields;
    }

    @Nullable
    public Bytes bytes() {
        return this.bytes;
    }

    public static class Builder
    implements ObjectBuilder<FielddataRequest> {
        @Nullable
        private List<String> fields;
        @Nullable
        private Bytes bytes;

        public Builder fields(@Nullable List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        @Override
        public FielddataRequest build() {
            return new FielddataRequest(this);
        }
    }
}

