/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat.allocation;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AllocationRecord
implements JsonpSerializable {
    @Nullable
    private final String shards;
    @Nullable
    private final String diskIndices;
    @Nullable
    private final String diskUsed;
    @Nullable
    private final String diskAvail;
    @Nullable
    private final String diskTotal;
    @Nullable
    private final String diskPercent;
    @Nullable
    private final String host;
    @Nullable
    private final String ip;
    @Nullable
    private final String node;
    public static final JsonpDeserializer<AllocationRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AllocationRecord::setupAllocationRecordDeserializer, Builder::build);

    public AllocationRecord(Builder builder) {
        this.shards = builder.shards;
        this.diskIndices = builder.diskIndices;
        this.diskUsed = builder.diskUsed;
        this.diskAvail = builder.diskAvail;
        this.diskTotal = builder.diskTotal;
        this.diskPercent = builder.diskPercent;
        this.host = builder.host;
        this.ip = builder.ip;
        this.node = builder.node;
    }

    public AllocationRecord(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String shards() {
        return this.shards;
    }

    @Nullable
    public String diskIndices() {
        return this.diskIndices;
    }

    @Nullable
    public String diskUsed() {
        return this.diskUsed;
    }

    @Nullable
    public String diskAvail() {
        return this.diskAvail;
    }

    @Nullable
    public String diskTotal() {
        return this.diskTotal;
    }

    @Nullable
    public String diskPercent() {
        return this.diskPercent;
    }

    @Nullable
    public String host() {
        return this.host;
    }

    @Nullable
    public String ip() {
        return this.ip;
    }

    @Nullable
    public String node() {
        return this.node;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.shards != null) {
            generator.writeKey("shards");
            generator.write(this.shards);
        }
        if (this.diskIndices != null) {
            generator.writeKey("disk.indices");
            generator.write(this.diskIndices);
        }
        if (this.diskUsed != null) {
            generator.writeKey("disk.used");
            generator.write(this.diskUsed);
        }
        if (this.diskAvail != null) {
            generator.writeKey("disk.avail");
            generator.write(this.diskAvail);
        }
        if (this.diskTotal != null) {
            generator.writeKey("disk.total");
            generator.write(this.diskTotal);
        }
        if (this.diskPercent != null) {
            generator.writeKey("disk.percent");
            generator.write(this.diskPercent);
        }
        if (this.host != null) {
            generator.writeKey("host");
            generator.write(this.host);
        }
        if (this.ip != null) {
            generator.writeKey("ip");
            generator.write(this.ip);
        }
        if (this.node != null) {
            generator.writeKey("node");
            generator.write(this.node);
        }
    }

    protected static void setupAllocationRecordDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::shards, JsonpDeserializer.stringDeserializer(), "shards", "s");
        op.add(Builder::diskIndices, JsonpDeserializer.stringDeserializer(), "disk.indices", "di", "diskIndices");
        op.add(Builder::diskUsed, JsonpDeserializer.stringDeserializer(), "disk.used", "du", "diskUsed");
        op.add(Builder::diskAvail, JsonpDeserializer.stringDeserializer(), "disk.avail", "da", "diskAvail");
        op.add(Builder::diskTotal, JsonpDeserializer.stringDeserializer(), "disk.total", "dt", "diskTotal");
        op.add(Builder::diskPercent, JsonpDeserializer.stringDeserializer(), "disk.percent", "dp", "diskPercent");
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host", "h");
        op.add(Builder::ip, JsonpDeserializer.stringDeserializer(), "ip", new String[0]);
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node", "n");
    }

    public static class Builder
    implements ObjectBuilder<AllocationRecord> {
        @Nullable
        private String shards;
        @Nullable
        private String diskIndices;
        @Nullable
        private String diskUsed;
        @Nullable
        private String diskAvail;
        @Nullable
        private String diskTotal;
        @Nullable
        private String diskPercent;
        @Nullable
        private String host;
        @Nullable
        private String ip;
        @Nullable
        private String node;

        public Builder shards(@Nullable String value) {
            this.shards = value;
            return this;
        }

        public Builder diskIndices(@Nullable String value) {
            this.diskIndices = value;
            return this;
        }

        public Builder diskUsed(@Nullable String value) {
            this.diskUsed = value;
            return this;
        }

        public Builder diskAvail(@Nullable String value) {
            this.diskAvail = value;
            return this;
        }

        public Builder diskTotal(@Nullable String value) {
            this.diskTotal = value;
            return this;
        }

        public Builder diskPercent(@Nullable String value) {
            this.diskPercent = value;
            return this;
        }

        public Builder host(@Nullable String value) {
            this.host = value;
            return this;
        }

        public Builder ip(@Nullable String value) {
            this.ip = value;
            return this;
        }

        public Builder node(@Nullable String value) {
            this.node = value;
            return this;
        }

        @Override
        public AllocationRecord build() {
            return new AllocationRecord(this);
        }
    }
}

