/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.reroute;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RerouteDecision
implements JsonpSerializable {
    private final String decider;
    private final String decision;
    private final String explanation;
    public static final JsonpDeserializer<RerouteDecision> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerouteDecision::setupRerouteDecisionDeserializer, Builder::build);

    public RerouteDecision(Builder builder) {
        this.decider = Objects.requireNonNull(builder.decider, "decider");
        this.decision = Objects.requireNonNull(builder.decision, "decision");
        this.explanation = Objects.requireNonNull(builder.explanation, "explanation");
    }

    public RerouteDecision(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String decider() {
        return this.decider;
    }

    public String decision() {
        return this.decision;
    }

    public String explanation() {
        return this.explanation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("decider");
        generator.write(this.decider);
        generator.writeKey("decision");
        generator.write(this.decision);
        generator.writeKey("explanation");
        generator.write(this.explanation);
    }

    protected static void setupRerouteDecisionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::decider, JsonpDeserializer.stringDeserializer(), "decider", new String[0]);
        op.add(Builder::decision, JsonpDeserializer.stringDeserializer(), "decision", new String[0]);
        op.add(Builder::explanation, JsonpDeserializer.stringDeserializer(), "explanation", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RerouteDecision> {
        private String decider;
        private String decision;
        private String explanation;

        public Builder decider(String value) {
            this.decider = value;
            return this;
        }

        public Builder decision(String value) {
            this.decision = value;
            return this;
        }

        public Builder explanation(String value) {
            this.explanation = value;
            return this;
        }

        @Override
        public RerouteDecision build() {
            return new RerouteDecision(this);
        }
    }
}

