/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class ClusterNetworkTypes
implements JsonpSerializable {
    private final Map<String, Integer> httpTypes;
    private final Map<String, Integer> transportTypes;
    public static final JsonpDeserializer<ClusterNetworkTypes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterNetworkTypes::setupClusterNetworkTypesDeserializer, Builder::build);

    public ClusterNetworkTypes(Builder builder) {
        this.httpTypes = ModelTypeHelper.unmodifiableNonNull(builder.httpTypes, "http_types");
        this.transportTypes = ModelTypeHelper.unmodifiableNonNull(builder.transportTypes, "transport_types");
    }

    public ClusterNetworkTypes(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, Integer> httpTypes() {
        return this.httpTypes;
    }

    public Map<String, Integer> transportTypes() {
        return this.transportTypes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("http_types");
        generator.writeStartObject();
        for (Map.Entry<String, Integer> item0 : this.httpTypes.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue().intValue());
        }
        generator.writeEnd();
        generator.writeKey("transport_types");
        generator.writeStartObject();
        for (Map.Entry<String, Integer> item0 : this.transportTypes.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue().intValue());
        }
        generator.writeEnd();
    }

    protected static void setupClusterNetworkTypesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::httpTypes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "http_types", new String[0]);
        op.add(Builder::transportTypes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "transport_types", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClusterNetworkTypes> {
        private Map<String, Integer> httpTypes;
        private Map<String, Integer> transportTypes;

        public Builder httpTypes(Map<String, Integer> value) {
            this.httpTypes = value;
            return this;
        }

        public Builder putHttpTypes(String key, Integer value) {
            if (this.httpTypes == null) {
                this.httpTypes = new HashMap<String, Integer>();
            }
            this.httpTypes.put(key, value);
            return this;
        }

        public Builder transportTypes(Map<String, Integer> value) {
            this.transportTypes = value;
            return this;
        }

        public Builder putTransportTypes(String key, Integer value) {
            if (this.transportTypes == null) {
                this.transportTypes = new HashMap<String, Integer>();
            }
            this.transportTypes.put(key, value);
            return this;
        }

        @Override
        public ClusterNetworkTypes build() {
            return new ClusterNetworkTypes(this);
        }
    }
}

