/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ClusterShardMetrics
implements JsonpSerializable {
    private final double avg;
    private final double max;
    private final double min;
    public static final JsonpDeserializer<ClusterShardMetrics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterShardMetrics::setupClusterShardMetricsDeserializer, Builder::build);

    public ClusterShardMetrics(Builder builder) {
        this.avg = Objects.requireNonNull(builder.avg, "avg");
        this.max = Objects.requireNonNull(builder.max, "max");
        this.min = Objects.requireNonNull(builder.min, "min");
    }

    public ClusterShardMetrics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public double avg() {
        return this.avg;
    }

    public double max() {
        return this.max;
    }

    public double min() {
        return this.min;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("avg");
        generator.write(this.avg);
        generator.writeKey("max");
        generator.write(this.max);
        generator.writeKey("min");
        generator.write(this.min);
    }

    protected static void setupClusterShardMetricsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::avg, JsonpDeserializer.doubleDeserializer(), "avg", new String[0]);
        op.add(Builder::max, JsonpDeserializer.doubleDeserializer(), "max", new String[0]);
        op.add(Builder::min, JsonpDeserializer.doubleDeserializer(), "min", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClusterShardMetrics> {
        private Double avg;
        private Double max;
        private Double min;

        public Builder avg(double value) {
            this.avg = value;
            return this;
        }

        public Builder max(double value) {
            this.max = value;
            return this;
        }

        public Builder min(double value) {
            this.min = value;
            return this;
        }

        @Override
        public ClusterShardMetrics build() {
            return new ClusterShardMetrics(this);
        }
    }
}

