/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.mapping.DynamicTemplate;
import co.elastic.clients.elasticsearch._types.mapping.FieldNamesField;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.RoutingField;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.mapping.SourceField;
import co.elastic.clients.elasticsearch.indices.PutMappingResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutMappingRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> index;
    @Nullable
    private final String type;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean includeTypeName;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    @Nullable
    private final Boolean writeIndexOnly;
    @Nullable
    private final Boolean dateDetection;
    @Nullable
    private final JsonValue dynamic;
    @Nullable
    private final List<String> dynamicDateFormats;
    @Nullable
    private final List<Map<String, DynamicTemplate>> dynamicTemplates;
    @Nullable
    private final FieldNamesField fieldNames;
    @Nullable
    private final Map<String, JsonData> meta;
    @Nullable
    private final Boolean numericDetection;
    @Nullable
    private final Map<String, Property> properties;
    @Nullable
    private final RoutingField routing;
    @Nullable
    private final SourceField source;
    @Nullable
    private final Map<String, RuntimeField> runtime;
    public static final JsonpDeserializer<PutMappingRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutMappingRequest::setupPutMappingRequestDeserializer, Builder::build);
    public static final Endpoint<PutMappingRequest, PutMappingResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutMappingRequest, PutMappingResponse>(request -> "PUT", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.type() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_mapping");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/_mapping");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_mapping");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/_mappings");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_mappings");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_mappings");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_mappings");
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_mapping");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.includeTypeName != null) {
            params.put("include_type_name", String.valueOf(request.includeTypeName));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.writeIndexOnly != null) {
            params.put("write_index_only", String.valueOf(request.writeIndexOnly));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutMappingResponse._DESERIALIZER);

    public PutMappingRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiableNonNull(builder.index, "index");
        this.type = builder.type;
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.includeTypeName = builder.includeTypeName;
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.writeIndexOnly = builder.writeIndexOnly;
        this.dateDetection = builder.dateDetection;
        this.dynamic = builder.dynamic;
        this.dynamicDateFormats = ModelTypeHelper.unmodifiable(builder.dynamicDateFormats);
        this.dynamicTemplates = ModelTypeHelper.unmodifiable(builder.dynamicTemplates);
        this.fieldNames = builder.fieldNames;
        this.meta = ModelTypeHelper.unmodifiable(builder.meta);
        this.numericDetection = builder.numericDetection;
        this.properties = ModelTypeHelper.unmodifiable(builder.properties);
        this.routing = builder.routing;
        this.source = builder.source;
        this.runtime = ModelTypeHelper.unmodifiable(builder.runtime);
    }

    public PutMappingRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> index() {
        return this.index;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public Boolean includeTypeName() {
        return this.includeTypeName;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Boolean writeIndexOnly() {
        return this.writeIndexOnly;
    }

    @Nullable
    public Boolean dateDetection() {
        return this.dateDetection;
    }

    @Nullable
    public JsonValue dynamic() {
        return this.dynamic;
    }

    @Nullable
    public List<String> dynamicDateFormats() {
        return this.dynamicDateFormats;
    }

    @Nullable
    public List<Map<String, DynamicTemplate>> dynamicTemplates() {
        return this.dynamicTemplates;
    }

    @Nullable
    public FieldNamesField fieldNames() {
        return this.fieldNames;
    }

    @Nullable
    public Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public Boolean numericDetection() {
        return this.numericDetection;
    }

    @Nullable
    public Map<String, Property> properties() {
        return this.properties;
    }

    @Nullable
    public RoutingField routing() {
        return this.routing;
    }

    @Nullable
    public SourceField source() {
        return this.source;
    }

    @Nullable
    public Map<String, RuntimeField> runtime() {
        return this.runtime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dateDetection != null) {
            generator.writeKey("date_detection");
            generator.write(this.dateDetection.booleanValue());
        }
        if (this.dynamic != null) {
            generator.writeKey("dynamic");
            generator.write(this.dynamic);
        }
        if (this.dynamicDateFormats != null) {
            generator.writeKey("dynamic_date_formats");
            generator.writeStartArray();
            for (String string : this.dynamicDateFormats) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.dynamicTemplates != null) {
            generator.writeKey("dynamic_templates");
            generator.writeStartArray();
            for (Map map : this.dynamicTemplates) {
                generator.writeStartObject();
                for (Map.Entry item1 : map.entrySet()) {
                    generator.writeKey((String)item1.getKey());
                    ((DynamicTemplate)item1.getValue()).serialize(generator, mapper);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.fieldNames != null) {
            generator.writeKey("_field_names");
            this.fieldNames.serialize(generator, mapper);
        }
        if (this.meta != null) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.numericDetection != null) {
            generator.writeKey("numeric_detection");
            generator.write(this.numericDetection.booleanValue());
        }
        if (this.properties != null) {
            generator.writeKey("properties");
            generator.writeStartObject();
            for (Map.Entry entry : this.properties.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((Property)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.routing != null) {
            generator.writeKey("_routing");
            this.routing.serialize(generator, mapper);
        }
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
        if (this.runtime != null) {
            generator.writeKey("runtime");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtime.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutMappingRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::dateDetection, JsonpDeserializer.booleanDeserializer(), "date_detection", new String[0]);
        op.add(Builder::dynamic, JsonpDeserializer.jsonValueDeserializer(), "dynamic", new String[0]);
        op.add(Builder::dynamicDateFormats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "dynamic_date_formats", new String[0]);
        op.add(Builder::dynamicTemplates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(DynamicTemplate._DESERIALIZER)), "dynamic_templates", new String[0]);
        op.add(Builder::fieldNames, FieldNamesField._DESERIALIZER, "_field_names", new String[0]);
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta", new String[0]);
        op.add(Builder::numericDetection, JsonpDeserializer.booleanDeserializer(), "numeric_detection", new String[0]);
        op.add(Builder::properties, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "properties", new String[0]);
        op.add(Builder::routing, RoutingField._DESERIALIZER, "_routing", new String[0]);
        op.add(Builder::source, SourceField._DESERIALIZER, "_source", new String[0]);
        op.add(Builder::runtime, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutMappingRequest> {
        private List<String> index;
        @Nullable
        private String type;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean includeTypeName;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;
        @Nullable
        private Boolean writeIndexOnly;
        @Nullable
        private Boolean dateDetection;
        @Nullable
        private JsonValue dynamic;
        @Nullable
        private List<String> dynamicDateFormats;
        @Nullable
        private List<Map<String, DynamicTemplate>> dynamicTemplates;
        @Nullable
        private FieldNamesField fieldNames;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Boolean numericDetection;
        @Nullable
        private Map<String, Property> properties;
        @Nullable
        private RoutingField routing;
        @Nullable
        private SourceField source;
        @Nullable
        private Map<String, RuntimeField> runtime;

        public Builder index(List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder includeTypeName(@Nullable Boolean value) {
            this.includeTypeName = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder writeIndexOnly(@Nullable Boolean value) {
            this.writeIndexOnly = value;
            return this;
        }

        public Builder dateDetection(@Nullable Boolean value) {
            this.dateDetection = value;
            return this;
        }

        public Builder dynamic(@Nullable JsonValue value) {
            this.dynamic = value;
            return this;
        }

        public Builder dynamicDateFormats(@Nullable List<String> value) {
            this.dynamicDateFormats = value;
            return this;
        }

        public Builder dynamicDateFormats(String ... value) {
            this.dynamicDateFormats = Arrays.asList(value);
            return this;
        }

        public Builder addDynamicDateFormats(String value) {
            if (this.dynamicDateFormats == null) {
                this.dynamicDateFormats = new ArrayList<String>();
            }
            this.dynamicDateFormats.add(value);
            return this;
        }

        public Builder dynamicTemplates(@Nullable List<Map<String, DynamicTemplate>> value) {
            this.dynamicTemplates = value;
            return this;
        }

        public Builder dynamicTemplates(Map<String, DynamicTemplate> ... value) {
            this.dynamicTemplates = Arrays.asList(value);
            return this;
        }

        public Builder addDynamicTemplates(Map<String, DynamicTemplate> value) {
            if (this.dynamicTemplates == null) {
                this.dynamicTemplates = new ArrayList<Map<String, DynamicTemplate>>();
            }
            this.dynamicTemplates.add(value);
            return this;
        }

        public Builder fieldNames(@Nullable FieldNamesField value) {
            this.fieldNames = value;
            return this;
        }

        public Builder fieldNames(Function<FieldNamesField.Builder, ObjectBuilder<FieldNamesField>> fn) {
            return this.fieldNames(fn.apply(new FieldNamesField.Builder()).build());
        }

        public Builder meta(@Nullable Map<String, JsonData> value) {
            this.meta = value;
            return this;
        }

        public Builder putMeta(String key, JsonData value) {
            if (this.meta == null) {
                this.meta = new HashMap<String, JsonData>();
            }
            this.meta.put(key, value);
            return this;
        }

        public Builder numericDetection(@Nullable Boolean value) {
            this.numericDetection = value;
            return this;
        }

        public Builder properties(@Nullable Map<String, Property> value) {
            this.properties = value;
            return this;
        }

        public Builder putProperties(String key, Property value) {
            if (this.properties == null) {
                this.properties = new HashMap<String, Property>();
            }
            this.properties.put(key, value);
            return this;
        }

        public Builder properties(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.properties(Collections.singletonMap(key, fn.apply(new Property.Builder()).build()));
        }

        public Builder putProperties(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.putProperties(key, fn.apply(new Property.Builder()).build());
        }

        public Builder routing(@Nullable RoutingField value) {
            this.routing = value;
            return this;
        }

        public Builder routing(Function<RoutingField.Builder, ObjectBuilder<RoutingField>> fn) {
            return this.routing(fn.apply(new RoutingField.Builder()).build());
        }

        public Builder source(@Nullable SourceField value) {
            this.source = value;
            return this;
        }

        public Builder source(Function<SourceField.Builder, ObjectBuilder<SourceField>> fn) {
            return this.source(fn.apply(new SourceField.Builder()).build());
        }

        public Builder runtime(@Nullable Map<String, RuntimeField> value) {
            this.runtime = value;
            return this;
        }

        public Builder putRuntime(String key, RuntimeField value) {
            if (this.runtime == null) {
                this.runtime = new HashMap<String, RuntimeField>();
            }
            this.runtime.put(key, value);
            return this;
        }

        public Builder runtime(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtime(Collections.singletonMap(key, fn.apply(new RuntimeField.Builder()).build()));
        }

        public Builder putRuntime(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.putRuntime(key, fn.apply(new RuntimeField.Builder()).build());
        }

        @Override
        public PutMappingRequest build() {
            return new PutMappingRequest(this);
        }
    }
}

