/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.analyze;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AnalyzeToken
implements JsonpSerializable {
    private final long endOffset;
    private final long position;
    @Nullable
    private final Long positionLength;
    private final long startOffset;
    private final String token;
    private final String type;
    public static final JsonpDeserializer<AnalyzeToken> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalyzeToken::setupAnalyzeTokenDeserializer, Builder::build);

    public AnalyzeToken(Builder builder) {
        this.endOffset = Objects.requireNonNull(builder.endOffset, "end_offset");
        this.position = Objects.requireNonNull(builder.position, "position");
        this.positionLength = builder.positionLength;
        this.startOffset = Objects.requireNonNull(builder.startOffset, "start_offset");
        this.token = Objects.requireNonNull(builder.token, "token");
        this.type = Objects.requireNonNull(builder.type, "type");
    }

    public AnalyzeToken(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long endOffset() {
        return this.endOffset;
    }

    public long position() {
        return this.position;
    }

    @Nullable
    public Long positionLength() {
        return this.positionLength;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public String token() {
        return this.token;
    }

    public String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("end_offset");
        generator.write(this.endOffset);
        generator.writeKey("position");
        generator.write(this.position);
        if (this.positionLength != null) {
            generator.writeKey("position_length");
            generator.write(this.positionLength.longValue());
        }
        generator.writeKey("start_offset");
        generator.write(this.startOffset);
        generator.writeKey("token");
        generator.write(this.token);
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupAnalyzeTokenDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::endOffset, JsonpDeserializer.longDeserializer(), "end_offset", new String[0]);
        op.add(Builder::position, JsonpDeserializer.longDeserializer(), "position", new String[0]);
        op.add(Builder::positionLength, JsonpDeserializer.longDeserializer(), "position_length", new String[0]);
        op.add(Builder::startOffset, JsonpDeserializer.longDeserializer(), "start_offset", new String[0]);
        op.add(Builder::token, JsonpDeserializer.stringDeserializer(), "token", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AnalyzeToken> {
        private Long endOffset;
        private Long position;
        @Nullable
        private Long positionLength;
        private Long startOffset;
        private String token;
        private String type;

        public Builder endOffset(long value) {
            this.endOffset = value;
            return this;
        }

        public Builder position(long value) {
            this.position = value;
            return this;
        }

        public Builder positionLength(@Nullable Long value) {
            this.positionLength = value;
            return this;
        }

        public Builder startOffset(long value) {
            this.startOffset = value;
            return this;
        }

        public Builder token(String value) {
            this.token = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        public AnalyzeToken build() {
            return new AnalyzeToken(this);
        }
    }
}

