/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.analyze;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ExplainAnalyzeToken
implements JsonpSerializable {
    private final String bytes;
    private final long endOffset;
    @Nullable
    private final Boolean keyword;
    private final long position;
    private final long positionlength;
    private final long startOffset;
    private final long termfrequency;
    private final String token;
    private final String type;
    public static final JsonpDeserializer<ExplainAnalyzeToken> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExplainAnalyzeToken::setupExplainAnalyzeTokenDeserializer, Builder::build);

    public ExplainAnalyzeToken(Builder builder) {
        this.bytes = Objects.requireNonNull(builder.bytes, "bytes");
        this.endOffset = Objects.requireNonNull(builder.endOffset, "end_offset");
        this.keyword = builder.keyword;
        this.position = Objects.requireNonNull(builder.position, "position");
        this.positionlength = Objects.requireNonNull(builder.positionlength, "positionLength");
        this.startOffset = Objects.requireNonNull(builder.startOffset, "start_offset");
        this.termfrequency = Objects.requireNonNull(builder.termfrequency, "termFrequency");
        this.token = Objects.requireNonNull(builder.token, "token");
        this.type = Objects.requireNonNull(builder.type, "type");
    }

    public ExplainAnalyzeToken(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String bytes() {
        return this.bytes;
    }

    public long endOffset() {
        return this.endOffset;
    }

    @Nullable
    public Boolean keyword() {
        return this.keyword;
    }

    public long position() {
        return this.position;
    }

    public long positionlength() {
        return this.positionlength;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long termfrequency() {
        return this.termfrequency;
    }

    public String token() {
        return this.token;
    }

    public String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bytes");
        generator.write(this.bytes);
        generator.writeKey("end_offset");
        generator.write(this.endOffset);
        if (this.keyword != null) {
            generator.writeKey("keyword");
            generator.write(this.keyword.booleanValue());
        }
        generator.writeKey("position");
        generator.write(this.position);
        generator.writeKey("positionLength");
        generator.write(this.positionlength);
        generator.writeKey("start_offset");
        generator.write(this.startOffset);
        generator.writeKey("termFrequency");
        generator.write(this.termfrequency);
        generator.writeKey("token");
        generator.write(this.token);
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupExplainAnalyzeTokenDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::bytes, JsonpDeserializer.stringDeserializer(), "bytes", new String[0]);
        op.add(Builder::endOffset, JsonpDeserializer.longDeserializer(), "end_offset", new String[0]);
        op.add(Builder::keyword, JsonpDeserializer.booleanDeserializer(), "keyword", new String[0]);
        op.add(Builder::position, JsonpDeserializer.longDeserializer(), "position", new String[0]);
        op.add(Builder::positionlength, JsonpDeserializer.longDeserializer(), "positionLength", new String[0]);
        op.add(Builder::startOffset, JsonpDeserializer.longDeserializer(), "start_offset", new String[0]);
        op.add(Builder::termfrequency, JsonpDeserializer.longDeserializer(), "termFrequency", new String[0]);
        op.add(Builder::token, JsonpDeserializer.stringDeserializer(), "token", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ExplainAnalyzeToken> {
        private String bytes;
        private Long endOffset;
        @Nullable
        private Boolean keyword;
        private Long position;
        private Long positionlength;
        private Long startOffset;
        private Long termfrequency;
        private String token;
        private String type;

        public Builder bytes(String value) {
            this.bytes = value;
            return this;
        }

        public Builder endOffset(long value) {
            this.endOffset = value;
            return this;
        }

        public Builder keyword(@Nullable Boolean value) {
            this.keyword = value;
            return this;
        }

        public Builder position(long value) {
            this.position = value;
            return this;
        }

        public Builder positionlength(long value) {
            this.positionlength = value;
            return this;
        }

        public Builder startOffset(long value) {
            this.startOffset = value;
            return this;
        }

        public Builder termfrequency(long value) {
            this.termfrequency = value;
            return this;
        }

        public Builder token(String value) {
            this.token = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        public ExplainAnalyzeToken build() {
            return new ExplainAnalyzeToken(this);
        }
    }
}

