/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.Influence;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class AnomalyCause
implements JsonpSerializable {
    private final List<Double> actual;
    private final String byFieldName;
    private final String byFieldValue;
    private final String correlatedByFieldValue;
    private final String fieldName;
    private final String function;
    private final String functionDescription;
    private final List<Influence> influencers;
    private final String overFieldName;
    private final String overFieldValue;
    private final String partitionFieldName;
    private final String partitionFieldValue;
    private final double probability;
    private final List<Double> typical;
    public static final JsonpDeserializer<AnomalyCause> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnomalyCause::setupAnomalyCauseDeserializer, Builder::build);

    public AnomalyCause(Builder builder) {
        this.actual = ModelTypeHelper.unmodifiableNonNull(builder.actual, "actual");
        this.byFieldName = Objects.requireNonNull(builder.byFieldName, "by_field_name");
        this.byFieldValue = Objects.requireNonNull(builder.byFieldValue, "by_field_value");
        this.correlatedByFieldValue = Objects.requireNonNull(builder.correlatedByFieldValue, "correlated_by_field_value");
        this.fieldName = Objects.requireNonNull(builder.fieldName, "field_name");
        this.function = Objects.requireNonNull(builder.function, "function");
        this.functionDescription = Objects.requireNonNull(builder.functionDescription, "function_description");
        this.influencers = ModelTypeHelper.unmodifiableNonNull(builder.influencers, "influencers");
        this.overFieldName = Objects.requireNonNull(builder.overFieldName, "over_field_name");
        this.overFieldValue = Objects.requireNonNull(builder.overFieldValue, "over_field_value");
        this.partitionFieldName = Objects.requireNonNull(builder.partitionFieldName, "partition_field_name");
        this.partitionFieldValue = Objects.requireNonNull(builder.partitionFieldValue, "partition_field_value");
        this.probability = Objects.requireNonNull(builder.probability, "probability");
        this.typical = ModelTypeHelper.unmodifiableNonNull(builder.typical, "typical");
    }

    public AnomalyCause(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<Double> actual() {
        return this.actual;
    }

    public String byFieldName() {
        return this.byFieldName;
    }

    public String byFieldValue() {
        return this.byFieldValue;
    }

    public String correlatedByFieldValue() {
        return this.correlatedByFieldValue;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String function() {
        return this.function;
    }

    public String functionDescription() {
        return this.functionDescription;
    }

    public List<Influence> influencers() {
        return this.influencers;
    }

    public String overFieldName() {
        return this.overFieldName;
    }

    public String overFieldValue() {
        return this.overFieldValue;
    }

    public String partitionFieldName() {
        return this.partitionFieldName;
    }

    public String partitionFieldValue() {
        return this.partitionFieldValue;
    }

    public double probability() {
        return this.probability;
    }

    public List<Double> typical() {
        return this.typical;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actual");
        generator.writeStartArray();
        for (Double d : this.actual) {
            generator.write(d.doubleValue());
        }
        generator.writeEnd();
        generator.writeKey("by_field_name");
        generator.write(this.byFieldName);
        generator.writeKey("by_field_value");
        generator.write(this.byFieldValue);
        generator.writeKey("correlated_by_field_value");
        generator.write(this.correlatedByFieldValue);
        generator.writeKey("field_name");
        generator.write(this.fieldName);
        generator.writeKey("function");
        generator.write(this.function);
        generator.writeKey("function_description");
        generator.write(this.functionDescription);
        generator.writeKey("influencers");
        generator.writeStartArray();
        for (Influence influence : this.influencers) {
            influence.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("over_field_name");
        generator.write(this.overFieldName);
        generator.writeKey("over_field_value");
        generator.write(this.overFieldValue);
        generator.writeKey("partition_field_name");
        generator.write(this.partitionFieldName);
        generator.writeKey("partition_field_value");
        generator.write(this.partitionFieldValue);
        generator.writeKey("probability");
        generator.write(this.probability);
        generator.writeKey("typical");
        generator.writeStartArray();
        for (Double d : this.typical) {
            generator.write(d.doubleValue());
        }
        generator.writeEnd();
    }

    protected static void setupAnomalyCauseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actual, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "actual", new String[0]);
        op.add(Builder::byFieldName, JsonpDeserializer.stringDeserializer(), "by_field_name", new String[0]);
        op.add(Builder::byFieldValue, JsonpDeserializer.stringDeserializer(), "by_field_value", new String[0]);
        op.add(Builder::correlatedByFieldValue, JsonpDeserializer.stringDeserializer(), "correlated_by_field_value", new String[0]);
        op.add(Builder::fieldName, JsonpDeserializer.stringDeserializer(), "field_name", new String[0]);
        op.add(Builder::function, JsonpDeserializer.stringDeserializer(), "function", new String[0]);
        op.add(Builder::functionDescription, JsonpDeserializer.stringDeserializer(), "function_description", new String[0]);
        op.add(Builder::influencers, JsonpDeserializer.arrayDeserializer(Influence._DESERIALIZER), "influencers", new String[0]);
        op.add(Builder::overFieldName, JsonpDeserializer.stringDeserializer(), "over_field_name", new String[0]);
        op.add(Builder::overFieldValue, JsonpDeserializer.stringDeserializer(), "over_field_value", new String[0]);
        op.add(Builder::partitionFieldName, JsonpDeserializer.stringDeserializer(), "partition_field_name", new String[0]);
        op.add(Builder::partitionFieldValue, JsonpDeserializer.stringDeserializer(), "partition_field_value", new String[0]);
        op.add(Builder::probability, JsonpDeserializer.doubleDeserializer(), "probability", new String[0]);
        op.add(Builder::typical, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "typical", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AnomalyCause> {
        private List<Double> actual;
        private String byFieldName;
        private String byFieldValue;
        private String correlatedByFieldValue;
        private String fieldName;
        private String function;
        private String functionDescription;
        private List<Influence> influencers;
        private String overFieldName;
        private String overFieldValue;
        private String partitionFieldName;
        private String partitionFieldValue;
        private Double probability;
        private List<Double> typical;

        public Builder actual(List<Double> value) {
            this.actual = value;
            return this;
        }

        public Builder actual(Double ... value) {
            this.actual = Arrays.asList(value);
            return this;
        }

        public Builder addActual(Double value) {
            if (this.actual == null) {
                this.actual = new ArrayList<Double>();
            }
            this.actual.add(value);
            return this;
        }

        public Builder byFieldName(String value) {
            this.byFieldName = value;
            return this;
        }

        public Builder byFieldValue(String value) {
            this.byFieldValue = value;
            return this;
        }

        public Builder correlatedByFieldValue(String value) {
            this.correlatedByFieldValue = value;
            return this;
        }

        public Builder fieldName(String value) {
            this.fieldName = value;
            return this;
        }

        public Builder function(String value) {
            this.function = value;
            return this;
        }

        public Builder functionDescription(String value) {
            this.functionDescription = value;
            return this;
        }

        public Builder influencers(List<Influence> value) {
            this.influencers = value;
            return this;
        }

        public Builder influencers(Influence ... value) {
            this.influencers = Arrays.asList(value);
            return this;
        }

        public Builder addInfluencers(Influence value) {
            if (this.influencers == null) {
                this.influencers = new ArrayList<Influence>();
            }
            this.influencers.add(value);
            return this;
        }

        public Builder influencers(Function<Influence.Builder, ObjectBuilder<Influence>> fn) {
            return this.influencers(fn.apply(new Influence.Builder()).build());
        }

        public Builder addInfluencers(Function<Influence.Builder, ObjectBuilder<Influence>> fn) {
            return this.addInfluencers(fn.apply(new Influence.Builder()).build());
        }

        public Builder overFieldName(String value) {
            this.overFieldName = value;
            return this;
        }

        public Builder overFieldValue(String value) {
            this.overFieldValue = value;
            return this;
        }

        public Builder partitionFieldName(String value) {
            this.partitionFieldName = value;
            return this;
        }

        public Builder partitionFieldValue(String value) {
            this.partitionFieldValue = value;
            return this;
        }

        public Builder probability(double value) {
            this.probability = value;
            return this;
        }

        public Builder typical(List<Double> value) {
            this.typical = value;
            return this;
        }

        public Builder typical(Double ... value) {
            this.typical = Arrays.asList(value);
            return this;
        }

        public Builder addTypical(Double value) {
            if (this.typical == null) {
                this.typical = new ArrayList<Double>();
            }
            this.typical.add(value);
            return this;
        }

        @Override
        public AnomalyCause build() {
            return new AnomalyCause(this);
        }
    }
}

