/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysisFeatureProcessor;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class DataframeAnalysisBase
implements JsonpSerializable {
    @Nullable
    private final Double alpha;
    private final String dependentVariable;
    @Nullable
    private final Double downsampleFactor;
    @Nullable
    private final Boolean earlyStoppingEnabled;
    @Nullable
    private final Double eta;
    @Nullable
    private final Double etaGrowthRatePerTree;
    @Nullable
    private final Double featureBagFraction;
    @Nullable
    private final List<DataframeAnalysisFeatureProcessor> featureProcessors;
    @Nullable
    private final Double gamma;
    @Nullable
    private final Double lambda;
    @Nullable
    private final Integer maxOptimizationRoundsPerHyperparameter;
    @Nullable
    private final Integer maxTrees;
    @Nullable
    private final Integer numTopFeatureImportanceValues;
    @Nullable
    private final String predictionFieldName;
    @Nullable
    private final Double randomizeSeed;
    @Nullable
    private final Integer softTreeDepthLimit;
    @Nullable
    private final Double softTreeDepthTolerance;
    @Nullable
    private final String trainingPercent;

    public DataframeAnalysisBase(AbstractBuilder<?> builder) {
        this.alpha = ((AbstractBuilder)builder).alpha;
        this.dependentVariable = Objects.requireNonNull(((AbstractBuilder)builder).dependentVariable, "dependent_variable");
        this.downsampleFactor = ((AbstractBuilder)builder).downsampleFactor;
        this.earlyStoppingEnabled = ((AbstractBuilder)builder).earlyStoppingEnabled;
        this.eta = ((AbstractBuilder)builder).eta;
        this.etaGrowthRatePerTree = ((AbstractBuilder)builder).etaGrowthRatePerTree;
        this.featureBagFraction = ((AbstractBuilder)builder).featureBagFraction;
        this.featureProcessors = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).featureProcessors);
        this.gamma = ((AbstractBuilder)builder).gamma;
        this.lambda = ((AbstractBuilder)builder).lambda;
        this.maxOptimizationRoundsPerHyperparameter = ((AbstractBuilder)builder).maxOptimizationRoundsPerHyperparameter;
        this.maxTrees = ((AbstractBuilder)builder).maxTrees;
        this.numTopFeatureImportanceValues = ((AbstractBuilder)builder).numTopFeatureImportanceValues;
        this.predictionFieldName = ((AbstractBuilder)builder).predictionFieldName;
        this.randomizeSeed = ((AbstractBuilder)builder).randomizeSeed;
        this.softTreeDepthLimit = ((AbstractBuilder)builder).softTreeDepthLimit;
        this.softTreeDepthTolerance = ((AbstractBuilder)builder).softTreeDepthTolerance;
        this.trainingPercent = ((AbstractBuilder)builder).trainingPercent;
    }

    @Nullable
    public Double alpha() {
        return this.alpha;
    }

    public String dependentVariable() {
        return this.dependentVariable;
    }

    @Nullable
    public Double downsampleFactor() {
        return this.downsampleFactor;
    }

    @Nullable
    public Boolean earlyStoppingEnabled() {
        return this.earlyStoppingEnabled;
    }

    @Nullable
    public Double eta() {
        return this.eta;
    }

    @Nullable
    public Double etaGrowthRatePerTree() {
        return this.etaGrowthRatePerTree;
    }

    @Nullable
    public Double featureBagFraction() {
        return this.featureBagFraction;
    }

    @Nullable
    public List<DataframeAnalysisFeatureProcessor> featureProcessors() {
        return this.featureProcessors;
    }

    @Nullable
    public Double gamma() {
        return this.gamma;
    }

    @Nullable
    public Double lambda() {
        return this.lambda;
    }

    @Nullable
    public Integer maxOptimizationRoundsPerHyperparameter() {
        return this.maxOptimizationRoundsPerHyperparameter;
    }

    @Nullable
    public Integer maxTrees() {
        return this.maxTrees;
    }

    @Nullable
    public Integer numTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    @Nullable
    public String predictionFieldName() {
        return this.predictionFieldName;
    }

    @Nullable
    public Double randomizeSeed() {
        return this.randomizeSeed;
    }

    @Nullable
    public Integer softTreeDepthLimit() {
        return this.softTreeDepthLimit;
    }

    @Nullable
    public Double softTreeDepthTolerance() {
        return this.softTreeDepthTolerance;
    }

    @Nullable
    public String trainingPercent() {
        return this.trainingPercent;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.alpha != null) {
            generator.writeKey("alpha");
            generator.write(this.alpha.doubleValue());
        }
        generator.writeKey("dependent_variable");
        generator.write(this.dependentVariable);
        if (this.downsampleFactor != null) {
            generator.writeKey("downsample_factor");
            generator.write(this.downsampleFactor.doubleValue());
        }
        if (this.earlyStoppingEnabled != null) {
            generator.writeKey("early_stopping_enabled");
            generator.write(this.earlyStoppingEnabled.booleanValue());
        }
        if (this.eta != null) {
            generator.writeKey("eta");
            generator.write(this.eta.doubleValue());
        }
        if (this.etaGrowthRatePerTree != null) {
            generator.writeKey("eta_growth_rate_per_tree");
            generator.write(this.etaGrowthRatePerTree.doubleValue());
        }
        if (this.featureBagFraction != null) {
            generator.writeKey("feature_bag_fraction");
            generator.write(this.featureBagFraction.doubleValue());
        }
        if (this.featureProcessors != null) {
            generator.writeKey("feature_processors");
            generator.writeStartArray();
            for (DataframeAnalysisFeatureProcessor item0 : this.featureProcessors) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.gamma != null) {
            generator.writeKey("gamma");
            generator.write(this.gamma.doubleValue());
        }
        if (this.lambda != null) {
            generator.writeKey("lambda");
            generator.write(this.lambda.doubleValue());
        }
        if (this.maxOptimizationRoundsPerHyperparameter != null) {
            generator.writeKey("max_optimization_rounds_per_hyperparameter");
            generator.write(this.maxOptimizationRoundsPerHyperparameter.intValue());
        }
        if (this.maxTrees != null) {
            generator.writeKey("max_trees");
            generator.write(this.maxTrees.intValue());
        }
        if (this.numTopFeatureImportanceValues != null) {
            generator.writeKey("num_top_feature_importance_values");
            generator.write(this.numTopFeatureImportanceValues.intValue());
        }
        if (this.predictionFieldName != null) {
            generator.writeKey("prediction_field_name");
            generator.write(this.predictionFieldName);
        }
        if (this.randomizeSeed != null) {
            generator.writeKey("randomize_seed");
            generator.write(this.randomizeSeed.doubleValue());
        }
        if (this.softTreeDepthLimit != null) {
            generator.writeKey("soft_tree_depth_limit");
            generator.write(this.softTreeDepthLimit.intValue());
        }
        if (this.softTreeDepthTolerance != null) {
            generator.writeKey("soft_tree_depth_tolerance");
            generator.write(this.softTreeDepthTolerance.doubleValue());
        }
        if (this.trainingPercent != null) {
            generator.writeKey("training_percent");
            generator.write(this.trainingPercent);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupDataframeAnalysisBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::alpha, JsonpDeserializer.doubleDeserializer(), "alpha", new String[0]);
        op.add(AbstractBuilder::dependentVariable, JsonpDeserializer.stringDeserializer(), "dependent_variable", new String[0]);
        op.add(AbstractBuilder::downsampleFactor, JsonpDeserializer.doubleDeserializer(), "downsample_factor", new String[0]);
        op.add(AbstractBuilder::earlyStoppingEnabled, JsonpDeserializer.booleanDeserializer(), "early_stopping_enabled", new String[0]);
        op.add(AbstractBuilder::eta, JsonpDeserializer.doubleDeserializer(), "eta", new String[0]);
        op.add(AbstractBuilder::etaGrowthRatePerTree, JsonpDeserializer.doubleDeserializer(), "eta_growth_rate_per_tree", new String[0]);
        op.add(AbstractBuilder::featureBagFraction, JsonpDeserializer.doubleDeserializer(), "feature_bag_fraction", new String[0]);
        op.add(AbstractBuilder::featureProcessors, JsonpDeserializer.arrayDeserializer(DataframeAnalysisFeatureProcessor._DESERIALIZER), "feature_processors", new String[0]);
        op.add(AbstractBuilder::gamma, JsonpDeserializer.doubleDeserializer(), "gamma", new String[0]);
        op.add(AbstractBuilder::lambda, JsonpDeserializer.doubleDeserializer(), "lambda", new String[0]);
        op.add(AbstractBuilder::maxOptimizationRoundsPerHyperparameter, JsonpDeserializer.integerDeserializer(), "max_optimization_rounds_per_hyperparameter", new String[0]);
        op.add(AbstractBuilder::maxTrees, JsonpDeserializer.integerDeserializer(), "max_trees", "maximum_number_trees");
        op.add(AbstractBuilder::numTopFeatureImportanceValues, JsonpDeserializer.integerDeserializer(), "num_top_feature_importance_values", new String[0]);
        op.add(AbstractBuilder::predictionFieldName, JsonpDeserializer.stringDeserializer(), "prediction_field_name", new String[0]);
        op.add(AbstractBuilder::randomizeSeed, JsonpDeserializer.doubleDeserializer(), "randomize_seed", new String[0]);
        op.add(AbstractBuilder::softTreeDepthLimit, JsonpDeserializer.integerDeserializer(), "soft_tree_depth_limit", new String[0]);
        op.add(AbstractBuilder::softTreeDepthTolerance, JsonpDeserializer.doubleDeserializer(), "soft_tree_depth_tolerance", new String[0]);
        op.add(AbstractBuilder::trainingPercent, JsonpDeserializer.stringDeserializer(), "training_percent", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        @Nullable
        private Double alpha;
        private String dependentVariable;
        @Nullable
        private Double downsampleFactor;
        @Nullable
        private Boolean earlyStoppingEnabled;
        @Nullable
        private Double eta;
        @Nullable
        private Double etaGrowthRatePerTree;
        @Nullable
        private Double featureBagFraction;
        @Nullable
        private List<DataframeAnalysisFeatureProcessor> featureProcessors;
        @Nullable
        private Double gamma;
        @Nullable
        private Double lambda;
        @Nullable
        private Integer maxOptimizationRoundsPerHyperparameter;
        @Nullable
        private Integer maxTrees;
        @Nullable
        private Integer numTopFeatureImportanceValues;
        @Nullable
        private String predictionFieldName;
        @Nullable
        private Double randomizeSeed;
        @Nullable
        private Integer softTreeDepthLimit;
        @Nullable
        private Double softTreeDepthTolerance;
        @Nullable
        private String trainingPercent;

        protected AbstractBuilder() {
        }

        public BuilderT alpha(@Nullable Double value) {
            this.alpha = value;
            return this.self();
        }

        public BuilderT dependentVariable(String value) {
            this.dependentVariable = value;
            return this.self();
        }

        public BuilderT downsampleFactor(@Nullable Double value) {
            this.downsampleFactor = value;
            return this.self();
        }

        public BuilderT earlyStoppingEnabled(@Nullable Boolean value) {
            this.earlyStoppingEnabled = value;
            return this.self();
        }

        public BuilderT eta(@Nullable Double value) {
            this.eta = value;
            return this.self();
        }

        public BuilderT etaGrowthRatePerTree(@Nullable Double value) {
            this.etaGrowthRatePerTree = value;
            return this.self();
        }

        public BuilderT featureBagFraction(@Nullable Double value) {
            this.featureBagFraction = value;
            return this.self();
        }

        public BuilderT featureProcessors(@Nullable List<DataframeAnalysisFeatureProcessor> value) {
            this.featureProcessors = value;
            return this.self();
        }

        public BuilderT featureProcessors(DataframeAnalysisFeatureProcessor ... value) {
            this.featureProcessors = Arrays.asList(value);
            return this.self();
        }

        public BuilderT addFeatureProcessors(DataframeAnalysisFeatureProcessor value) {
            if (this.featureProcessors == null) {
                this.featureProcessors = new ArrayList<DataframeAnalysisFeatureProcessor>();
            }
            this.featureProcessors.add(value);
            return this.self();
        }

        public BuilderT featureProcessors(Function<DataframeAnalysisFeatureProcessor.Builder, ObjectBuilder<DataframeAnalysisFeatureProcessor>> fn) {
            return this.featureProcessors(fn.apply(new DataframeAnalysisFeatureProcessor.Builder()).build());
        }

        public BuilderT addFeatureProcessors(Function<DataframeAnalysisFeatureProcessor.Builder, ObjectBuilder<DataframeAnalysisFeatureProcessor>> fn) {
            return this.addFeatureProcessors(fn.apply(new DataframeAnalysisFeatureProcessor.Builder()).build());
        }

        public BuilderT gamma(@Nullable Double value) {
            this.gamma = value;
            return this.self();
        }

        public BuilderT lambda(@Nullable Double value) {
            this.lambda = value;
            return this.self();
        }

        public BuilderT maxOptimizationRoundsPerHyperparameter(@Nullable Integer value) {
            this.maxOptimizationRoundsPerHyperparameter = value;
            return this.self();
        }

        public BuilderT maxTrees(@Nullable Integer value) {
            this.maxTrees = value;
            return this.self();
        }

        public BuilderT numTopFeatureImportanceValues(@Nullable Integer value) {
            this.numTopFeatureImportanceValues = value;
            return this.self();
        }

        public BuilderT predictionFieldName(@Nullable String value) {
            this.predictionFieldName = value;
            return this.self();
        }

        public BuilderT randomizeSeed(@Nullable Double value) {
            this.randomizeSeed = value;
            return this.self();
        }

        public BuilderT softTreeDepthLimit(@Nullable Integer value) {
            this.softTreeDepthLimit = value;
            return this.self();
        }

        public BuilderT softTreeDepthTolerance(@Nullable Double value) {
            this.softTreeDepthTolerance = value;
            return this.self();
        }

        public BuilderT trainingPercent(@Nullable String value) {
            this.trainingPercent = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

