/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DeleteCalendarEventResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public final class DeleteCalendarEventRequest
extends RequestBase {
    private final String calendarId;
    private final String eventId;
    public static final Endpoint<DeleteCalendarEventRequest, DeleteCalendarEventResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteCalendarEventRequest, DeleteCalendarEventResponse>(request -> "DELETE", request -> {
        boolean _calendarId = true;
        int _eventId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/calendars");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.calendarId, buf);
            buf.append("/events");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.eventId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, DeleteCalendarEventResponse._DESERIALIZER);

    public DeleteCalendarEventRequest(Builder builder) {
        this.calendarId = Objects.requireNonNull(builder.calendarId, "calendar_id");
        this.eventId = Objects.requireNonNull(builder.eventId, "event_id");
    }

    public DeleteCalendarEventRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String calendarId() {
        return this.calendarId;
    }

    public String eventId() {
        return this.eventId;
    }

    public static class Builder
    implements ObjectBuilder<DeleteCalendarEventRequest> {
        private String calendarId;
        private String eventId;

        public Builder calendarId(String value) {
            this.calendarId = value;
            return this;
        }

        public Builder eventId(String value) {
            this.eventId = value;
            return this;
        }

        @Override
        public DeleteCalendarEventRequest build() {
            return new DeleteCalendarEventRequest(this);
        }
    }
}

