/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DeleteFilterResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public final class DeleteFilterRequest
extends RequestBase {
    private final String filterId;
    public static final Endpoint<DeleteFilterRequest, DeleteFilterResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteFilterRequest, DeleteFilterResponse>(request -> "DELETE", request -> {
        boolean _filterId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/filters");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.filterId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, DeleteFilterResponse._DESERIALIZER);

    public DeleteFilterRequest(Builder builder) {
        this.filterId = Objects.requireNonNull(builder.filterId, "filter_id");
    }

    public DeleteFilterRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String filterId() {
        return this.filterId;
    }

    public static class Builder
    implements ObjectBuilder<DeleteFilterRequest> {
        private String filterId;

        public Builder filterId(String value) {
            this.filterId = value;
            return this;
        }

        @Override
        public DeleteFilterRequest build() {
            return new DeleteFilterRequest(this);
        }
    }
}

